/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;

public class ConfigurationHelper {
    public static String getStringProperty(String propName, String def, Map<String, ?> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (!(prop instanceof String)) {
            return prop.toString();
        }
        return (String)prop;
    }

    public static int getIntProperty(String propName, int def, Map<String, ?> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Integer.valueOf((String)prop);
        }
        if (!(prop instanceof Number)) {
            ActiveMQClientLogger.LOGGER.propertyNotInteger(propName, prop.getClass().getName());
            return def;
        }
        return ((Number)prop).intValue();
    }

    public static long getLongProperty(String propName, long def, Map<String, ?> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Long.valueOf((String)prop);
        }
        if (!(prop instanceof Number)) {
            ActiveMQClientLogger.LOGGER.propertyNotLong(propName, prop.getClass().getName());
            return def;
        }
        return ((Number)prop).longValue();
    }

    public static boolean getBooleanProperty(String propName, boolean def, Map<String, ?> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        if (prop instanceof String) {
            return Boolean.valueOf((String)prop);
        }
        if (!(prop instanceof Boolean)) {
            ActiveMQClientLogger.LOGGER.propertyNotBoolean(propName, prop.getClass().getName());
            return def;
        }
        return (Boolean)prop;
    }

    public static Set<String> checkKeys(Set<String> allowableKeys, Set<String> keys) {
        HashSet<String> invalid = new HashSet<String>();
        for (String key : keys) {
            if (allowableKeys.contains(key)) continue;
            invalid.add(key);
        }
        return invalid;
    }

    public static Set<String> checkKeysExist(Set<String> requiredKeys, Set<String> keys) {
        HashSet<String> invalid = new HashSet<String>(requiredKeys);
        for (String key : keys) {
            if (!requiredKeys.contains(key)) continue;
            invalid.remove(key);
        }
        return invalid;
    }

    public static String stringSetToCommaListString(Set<String> invalid) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String key : invalid) {
            sb.append(key);
            if (count != invalid.size() - 1) {
                sb.append(", ");
            }
            ++count;
        }
        return sb.toString();
    }

    public static String getPasswordProperty(String propName, String def, Map<String, ?> props, String defaultMaskPassword, String defaultPasswordCodec) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(propName);
        if (prop == null) {
            return def;
        }
        String value = prop.toString();
        Object useMaskObject = props.get(defaultMaskPassword);
        Boolean useMask = useMaskObject instanceof String ? Boolean.valueOf(Boolean.parseBoolean((String)useMaskObject)) : (Boolean)useMaskObject;
        String classImpl = (String)props.get(defaultPasswordCodec);
        try {
            return PasswordMaskingUtil.resolveMask(useMask, value, classImpl);
        }
        catch (Exception e) {
            throw ActiveMQClientMessageBundle.BUNDLE.errordecodingPassword(e);
        }
    }

    public static double getDoubleProperty(String name, double def, Map<String, ?> props) {
        if (props == null) {
            return def;
        }
        Object prop = props.get(name);
        if (prop == null) {
            return def;
        }
        String value = prop.toString();
        return Double.parseDouble(value);
    }
}

