/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.logging;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.naming.ConfigurationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.msc.service.StartException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.wildfly.iiop.openjdk.rmi.RMIIIOPViolationException;
import org.wildfly.iiop.openjdk.rmi.ir.IRConstructionException;

@MessageLogger(projectCode="WFLYIIOP", length=4)
public interface IIOPLogger
extends BasicLogger {
    public static final IIOPLogger ROOT_LOGGER = (IIOPLogger)Logger.getMessageLogger(IIOPLogger.class, (String)"org.wildfly.iiop.openjdk");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating IIOP Subsystem")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Error fetching CSIv2Policy")
    public void failedToFetchCSIv2Policy(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Caught exception while encoding GSSUPMechOID")
    public void caughtExceptionEncodingGSSUPMechOID(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Internal error")
    public void logInternalError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Failed to create CORBA naming context")
    public void failedToCreateNamingContext(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Unbind failed for %s")
    public void failedToUnbindObject(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Failed to obtain JSSE security domain with name %s")
    public void failedToObtainJSSEDomain(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="CORBA Naming Service started")
    public void corbaNamingServiceStarted();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="CORBA ORB Service started")
    public void corbaORBServiceStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Compatibility problem: Class javax.rmi.CORBA.ClassDesc does not conform to the Java(TM) Language to IDL Mapping Specification (01-06-07), section 1.3.5.11")
    public void warnClassDescDoesNotConformToSpec();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Could not deactivate IR object")
    public void warnCouldNotDeactivateIRObject(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Could not deactivate anonymous IR object")
    public void warnCouldNotDeactivateAnonIRObject(@Cause Throwable var1);

    @Message(id=13, value="SSL support has been enabled but no security domain or client/server SSL contexts have been specified")
    public OperationFailedException noSecurityDomainOrSSLContextsSpecified();

    @Message(id=14, value="Unexpected exception")
    public RuntimeException unexpectedException(@Cause Throwable var1);

    @Message(id=15, value="Unexpected ContextError in SAS reply")
    public NO_PERMISSION unexpectedContextErrorInSASReply(@Param int var1, @Param CompletionStatus var2);

    @Message(id=16, value="Could not parse SAS reply: %s")
    public MARSHAL errorParsingSASReply(Exception var1, @Param int var2, @Param CompletionStatus var3);

    @Message(id=17, value="Could not register initial reference for SASCurrent")
    public RuntimeException errorRegisteringSASCurrentInitRef(@Cause Throwable var1);

    @Message(id=18, value="SAS context does not exist")
    public NO_PERMISSION missingSASContext();

    @Message(id=19, value="Could not decode initial context token")
    public NO_PERMISSION errorDecodingInitContextToken();

    @Message(id=20, value="Could not decode target name in initial context token")
    public NO_PERMISSION errorDecodingTargetInContextToken();

    @Message(id=21, value="Could not decode incoming principal name")
    public NO_PERMISSION errorDecodingPrincipalName();

    @Message(id=22, value="Exception decoding context data in %s")
    public RuntimeException errorDecodingContextData(String var1, @Cause Throwable var2);

    @Message(id=23, value="Batch size not numeric: %s")
    public IllegalArgumentException illegalBatchSize(String var1);

    @Message(id=24, value="Error getting binding list")
    public NamingException errorGettingBindingList();

    @Message(id=25, value="Error generating object via object factory")
    public NamingException errorGeneratingObjectViaFactory();

    @Message(id=26, value="Error constructing context: either ORB or NamingContext must be supplied")
    public ConfigurationException errorConstructingCNCtx();

    @Message(id=27, value="%s does not name a NamingContext")
    public ConfigurationException notANamingContext(String var1);

    @Message(id=28, value="Cannot convert IOR to NamingContext: %s")
    public ConfigurationException errorConvertingIORToNamingCtx(String var1);

    @Message(id=29, value="ORB.resolve_initial_references(\"NameService\") does not return a NamingContext")
    public ConfigurationException errorResolvingNSInitRef();

    @Message(id=30, value="COS Name Service not registered with ORB under the name 'NameService'")
    public NamingException cosNamingNotRegisteredCorrectly();

    @Message(id=31, value="Cannot connect to ORB")
    public NamingException errorConnectingToORB();

    @Message(id=32, value="Invalid IOR or URL: %s")
    public NamingException invalidURLOrIOR(String var1);

    @Message(id=33, value="Invalid object reference:  %s")
    public NamingException invalidObjectReference(String var1);

    @Message(id=34, value="%s does not contain an IOR")
    public ConfigurationException urlDoesNotContainIOR(String var1);

    @Message(id=35, value="Only instances of org.omg.CORBA.Object can be bound")
    public IllegalArgumentException notACorbaObject();

    @Message(id=36, value="No object reference bound for specified name")
    public NamingException noReferenceFound();

    @Message(id=37, value="Invalid empty name")
    public InvalidNameException invalidEmptyName();

    @Message(id=38, value="%s: unescaped \\ at end of component")
    public InvalidNameException unescapedCharacter(String var1);

    @Message(id=39, value="%s: Invalid character being escaped")
    public InvalidNameException invalidEscapedCharacter(String var1);

    @Message(id=40, value="Invalid %s URL: %s")
    public MalformedURLException invalidURL(String var1, String var2);

    @Message(id=41, value="Problem with PortableRemoteObject.toStub(); object not exported or stub not found")
    public ConfigurationException problemInvokingPortableRemoteObjectToStub();

    @Message(id=42, value="Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)")
    public ConfigurationException cannotInvokePortableRemoteObjectToStub();

    @Message(id=43, value="No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)")
    public IllegalStateException noMethodDefForPortableRemoteObjectToStub();

    @Message(id=44, value="Problem invoking javax.rmi.CORBA.Stub.connect()")
    public ConfigurationException problemInvokingStubConnect();

    @Message(id=45, value="Cannot invoke javax.rmi.CORBA.Stub.connect()")
    public ConfigurationException cannotInvokeStubConnect();

    @Message(id=46, value="No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)")
    public IllegalStateException noMethodDefForStubConnect();

    @Message(id=47, value="Invalid IIOP URL version: %s")
    public MalformedURLException invalidIIOPURLVersion(String var1);

    @Message(id=48, value="javax.rmi packages not available")
    public ConfigurationException unavailableRMIPackages();

    @Message(id=49, value="ISO-Latin-1 decoder unavailable")
    public MalformedURLException unavailableISOLatin1Decoder();

    @Message(id=50, value="Invalid URI encoding: %s")
    public MalformedURLException invalidURIEncoding(String var1);

    @Message(id=51, value="Error configuring domain socket factory: failed to lookup JSSE security domain")
    public ConfigurationException failedToLookupJSSEDomain();

    @Message(id=52, value="keyManager[] is null for security domain %s")
    public IOException errorObtainingKeyManagers(String var1);

    @Message(id=53, value="Failed to get SSL context")
    public IOException failedToGetSSLContext(@Cause Throwable var1);

    @Message(id=54, value="Failed to start the JBoss Corba Naming Service")
    public StartException failedToStartJBossCOSNaming(@Cause Throwable var1);

    @Message(id=55, value="Foreign Transaction")
    public UnsupportedOperationException foreignTransaction();

    @Message(id=56, value="Exception raised during encoding")
    public RuntimeException errorEncodingContext(@Cause Throwable var1);

    @Message(id=57, value="Exception getting slot in TxServerInterceptor")
    public RuntimeException errorGettingSlotInTxInterceptor(@Cause Throwable var1);

    @Message(id=58, value="Exception setting slot in TxServerInterceptor")
    public RuntimeException errorSettingSlotInTxInterceptor(@Cause Throwable var1);

    @Message(id=59, value="Cannot analyze a null class")
    public IllegalArgumentException cannotAnalyzeNullClass();

    @Message(id=60, value="Bad type for a constant: %s")
    public IllegalArgumentException badConstantType(String var1);

    @Message(id=61, value="Cannot analyze special class: %s")
    public IllegalArgumentException cannotAnalyzeSpecialClass(String var1);

    @Message(id=62, value="Not an accessor: %s")
    public IllegalArgumentException notAnAccessor(String var1);

    @Message(id=63, value="Not a class or interface: %s")
    public IllegalArgumentException notAnClassOrInterface(String var1);

    @Message(id=64, value="Class %s is not an interface")
    public IllegalArgumentException notAnInterface(String var1);

    @Message(id=65, value="Not a primitive type: %s")
    public IllegalArgumentException notAPrimitive(String var1);

    @Message(id=66, value="Field %s of interface %s is a constant, but it is not primitive or String")
    public RMIIIOPViolationException badRMIIIOPConstantType(String var1, String var2, @Param String var3);

    @Message(id=67, value="Exception type %s must be a checked exception class")
    public RMIIIOPViolationException badRMIIIOPExceptionType(String var1, @Param String var2);

    @Message(id=68, value="All interface methods must throw javax.rmi.RemoteException but method %s of interface %s does not")
    public RMIIIOPViolationException badRMIIIOPMethodSignature(String var1, String var2, @Param String var3);

    @Message(id=69, value="Name cannot be null, empty or qualified")
    public IllegalArgumentException nameCannotBeNullEmptyOrQualified();

    @Message(id=70, value="Primitive types have no IR IDs")
    public IllegalArgumentException primitivesHaveNoIRIds();

    @Message(id=71, value="No SHA message digest available")
    public RuntimeException unavailableSHADigest(@Cause Throwable var1);

    @Message(id=72, value="Unknown primitive type: %s")
    public RuntimeException unknownPrimitiveType(String var1);

    @Message(id=73, value="Cannot analyze java.lang.String: it is a special case")
    public IllegalArgumentException cannotAnalyzeStringType();

    @Message(id=74, value="Cannot analyze java.lang.Class: it is a special case")
    public IllegalArgumentException cannotAnalyzeClassType();

    @Message(id=75, value="Value type %s cannot implement java.rmi.Remote")
    public RMIIIOPViolationException valueTypeCantImplementRemote(String var1, @Param String var2);

    @Message(id=76, value="Value type %s cannot be a proxy or inner class")
    public RMIIIOPViolationException valueTypeCantBeProxy(String var1);

    @Message(id=77, value="Error loading class %s")
    public RuntimeException errorLoadingClass(String var1, @Cause Throwable var2);

    @Message(id=78, value="No read method in helper class %s")
    public RuntimeException noReadMethodInHelper(String var1, @Cause Throwable var2);

    @Message(id=79, value="No write method in helper class %s")
    public RuntimeException noWriteMethodInHelper(String var1, @Cause Throwable var2);

    @Message(id=80, value="Error unmarshaling %s")
    public RuntimeException errorUnmarshaling(Class<?> var1, @Cause Throwable var2);

    @Message(id=81, value="Error marshaling %s")
    public RuntimeException errorMarshaling(Class<?> var1, @Cause Throwable var2);

    @Message(id=82, value="Cannot obtain exception repository id for %s")
    public RuntimeException cannotObtainExceptionRepositoryID(String var1, @Cause Throwable var2);

    @Message(id=83, value="Cannot marshal parameter: unexpected number of parameters")
    public RuntimeException errorMashalingParams();

    @Message(id=84, value="Cannot change RMI/IIOP mapping")
    public BAD_INV_ORDER cannotChangeRMIIIOPMapping();

    @Message(id=85, value="Bad kind %d for TypeCode")
    public RuntimeException badKindForTypeCode(int var1);

    @Message(id=86, value="Wrong interface repository")
    public IRConstructionException wrongInterfaceRepository();

    @Message(id=87, value="Duplicate repository name")
    public IRConstructionException duplicateRepositoryName();

    @Message(id=88, value="Invalid null class")
    public IllegalArgumentException invalidNullClass();

    @Message(id=89, value="Bad class %s for a constant")
    public IRConstructionException badClassForConstant(String var1);

    @Message(id=90, value="TypeCode for class %s is unknown")
    public IRConstructionException unknownTypeCodeForClass(String var1);

    @Message(id=91, value="TypeCode for class %s already established")
    public IRConstructionException duplicateTypeCodeForClass(String var1);

    @Message(id=92, value="Name collision while creating package")
    public IRConstructionException collisionWhileCreatingPackage();

    @Message(id=93, value="Class %s is not an array class")
    public IRConstructionException classIsNotArray(String var1);

    @Message(id=94, value="Cannot destroy RMI/IIOP mapping")
    public BAD_INV_ORDER cannotDestroyRMIIIOPMapping();

    @Message(id=95, value="Bad kind for super valuetype of %s")
    public IRConstructionException badKindForSuperValueType(String var1);

    @Message(id=96, value="ValueDef %s unable to resolve reference to implemented interface %s")
    public IRConstructionException errorResolvingRefToImplementedInterface(String var1, String var2);

    @Message(id=97, value="ValueDef %s unable to resolve reference to abstract base valuetype %s")
    public IRConstructionException errorResolvingRefToAbstractValuetype(String var1, String var2);

    @Message(id=98, value="Failed to resolve initial reference %s")
    public StartException errorResolvingInitRef(String var1, @Cause Throwable var2);

    @Message(id=99, value="Failed to create POA from parent")
    public StartException errorCreatingPOAFromParent(@Cause Throwable var1);

    @Message(id=100, value="Unable to instantiate POA: either the running ORB or the parent POA must be specified")
    public StartException invalidPOACreationArgs();

    @Message(id=101, value="Failed to activate POA")
    public StartException errorActivatingPOA(@Cause Throwable var1);

    @Message(id=102, value="Caught exception destroying Iterator %s")
    public INTERNAL exceptionDestroingIterator(String var1);

    @Message(id=103, value="IOR settings imply ssl connections usage, but secure connections have not been configured")
    public OperationFailedException sslNotConfigured();

    @Message(id=104, value="Inconsistent transport-config configuration: %s is supported, please configure it to %s value")
    public String inconsistentSupportedTransportConfig(String var1, String var2);

    @Message(id=105, value="Inconsistent transport-config configuration: %s is not supported, please remove it or configure it to none value")
    public String inconsistentUnsupportedTransportConfig(String var1);

    @Message(id=106, value="Inconsistent transport-config configuration: %s is set to true, please configure %s as required")
    public String inconsistentRequiredTransportConfig(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=109, value="SSL socket is required by server but secure connections have not been configured")
    public void cannotCreateSSLSocket();

    @Message(id=110, value="Client requires SSL but server does not support it")
    public IllegalStateException serverDoesNotSupportSsl();

    @Message(id=111, value="SSL has not been configured but ssl-port property has been specified - the connection will use clear-text protocol")
    public String sslPortWithoutSslConfiguration();

    @Message(id=113, value="Authentication context has been defined but it is ineffective because the security initializer is not set to 'elytron'")
    public OperationFailedException ineffectiveAuthenticationContextConfiguration();

    @Message(id=114, value="Elytron security initializer not supported in previous iiop-openjdk versions and can't be converted")
    public String elytronInitializerNotSupportedInPreviousVersions();

    @Message(id=115, value="No IIOP socket bindings have been configured")
    public IllegalStateException noSocketBindingsConfigured();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=117, value="CLEARTEXT in IIOP subsystem won't be used because server-requires-ssl parameter have been set to true")
    public void wontUseCleartextSocket();
}

