/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.metadata.Metadata;

public final class FilterNullValueConverter<K, V>
extends AbstractKeyValueFilterConverter<K, V, Object> {
    private final KeyValueFilter<K, V> filter;

    public FilterNullValueConverter(KeyValueFilter<K, V> filter) {
        this.filter = filter;
    }

    public Object filterAndConvert(K key, V value, Metadata metadata) {
        if (this.filter.accept(key, value, metadata)) {
            return NullValue.getInstance();
        }
        return null;
    }

    public static final class NullValue {
        private static final NullValue INSTANCE = new NullValue();

        private NullValue() {
        }

        public static NullValue getInstance() {
            return INSTANCE;
        }

        public static final class Externalizer
        extends AbstractExternalizer<NullValue> {
            public Set<Class<? extends NullValue>> getTypeClasses() {
                return Collections.singleton(NullValue.class);
            }

            public void writeObject(ObjectOutput output, NullValue object) {
            }

            public NullValue readObject(ObjectInput input) {
                return NullValue.getInstance();
            }

            public Integer getId() {
                return 1209;
            }
        }
    }

    public static final class Externalizer
    extends AbstractExternalizer<FilterNullValueConverter> {
        public Set<Class<? extends FilterNullValueConverter>> getTypeClasses() {
            return Collections.singleton(FilterNullValueConverter.class);
        }

        public void writeObject(ObjectOutput output, FilterNullValueConverter object) throws IOException {
            output.writeObject(object.filter);
        }

        public FilterNullValueConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            KeyValueFilter filter = (KeyValueFilter)input.readObject();
            return new FilterNullValueConverter(filter);
        }

        public Integer getId() {
            return 1208;
        }
    }
}

