/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.GetConstructorAction;
import org.jboss.weld.security.GetDeclaredFieldAction;
import org.jboss.weld.security.GetDeclaredFieldsAction;
import org.jboss.weld.security.SetAccessibleAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static void ensureAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(SetAccessibleAction.of(accessibleObject));
            } else {
                accessibleObject.setAccessible(true);
            }
        }
    }

    static <T> Constructor<T> getConstructor(Class<T> javaClass, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (System.getSecurityManager() != null) {
            try {
                return (Constructor)AccessController.doPrivileged(GetConstructorAction.of(javaClass, parameterTypes));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.getConstructor(parameterTypes);
    }

    static <T> Field getDeclaredField(Class<T> javaClass, String name) throws NoSuchFieldException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new GetDeclaredFieldAction(javaClass, name));
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof NoSuchFieldException) {
                    throw (NoSuchFieldException)e.getCause();
                }
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.getDeclaredField(name);
    }

    static boolean hasDeclaredField(Class<?> javaClass, String name) {
        Field[] fields = System.getSecurityManager() == null ? javaClass.getDeclaredFields() : AccessController.doPrivileged(new GetDeclaredFieldsAction(javaClass));
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

