/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.utils.BufferHelper;

public class CreateSharedQueueMessage_V2
extends CreateSharedQueueMessage {
    private RoutingType routingType;
    Integer maxConsumers;
    Boolean purgeOnNoConsumers;
    private Boolean exclusive;
    private Boolean lastValue;

    public CreateSharedQueueMessage_V2(SimpleString address, SimpleString queueName, RoutingType routingType, SimpleString filterString, boolean durable, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.routingType = routingType;
        this.maxConsumers = maxConsumers;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.exclusive = exclusive;
        this.lastValue = lastValue;
        this.requiresResponse = requiresResponse;
    }

    public CreateSharedQueueMessage_V2() {
        super((byte)-13);
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public Integer getMaxConsumers() {
        return this.maxConsumers;
    }

    public void setMaxConsumers(Integer maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public Boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public void setPurgeOnNoConsumers(Boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public Boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public Boolean isLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Boolean lastValue) {
        this.lastValue = lastValue;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", address=" + this.address);
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append(", durable=" + this.durable);
        buff.append(", routingType=" + this.routingType);
        buff.append(", maxConsumers=" + this.maxConsumers);
        buff.append(", purgeOnNoConsumers=" + this.purgeOnNoConsumers);
        buff.append(", exclusive=" + this.exclusive);
        buff.append(", lastValue=" + this.lastValue);
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeByte(this.routingType.getType());
        buffer.writeBoolean(this.requiresResponse);
        BufferHelper.writeNullableInteger(buffer, this.maxConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.purgeOnNoConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.exclusive);
        BufferHelper.writeNullableBoolean(buffer, this.lastValue);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.routingType = RoutingType.getType((byte)buffer.readByte());
        this.requiresResponse = buffer.readBoolean();
        if (buffer.readableBytes() > 0) {
            this.maxConsumers = BufferHelper.readNullableInteger(buffer);
            this.purgeOnNoConsumers = BufferHelper.readNullableBoolean(buffer);
            this.exclusive = BufferHelper.readNullableBoolean(buffer);
            this.lastValue = BufferHelper.readNullableBoolean(buffer);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.durable ? 1231 : 1237);
        result = 31 * result + this.routingType.getType();
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        result = 31 * result + (this.maxConsumers == null ? 0 : this.maxConsumers.hashCode());
        result = 31 * result + (this.purgeOnNoConsumers == null ? 0 : (this.purgeOnNoConsumers != false ? 1231 : 1237));
        result = 31 * result + (this.exclusive == null ? 0 : (this.exclusive != false ? 1231 : 1237));
        result = 31 * result + (this.lastValue == null ? 0 : (this.lastValue != false ? 1231 : 1237));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSharedQueueMessage_V2)) {
            return false;
        }
        CreateSharedQueueMessage_V2 other = (CreateSharedQueueMessage_V2)obj;
        if (this.address == null ? other.address != null : !this.address.equals((Object)other.address)) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals((Object)other.filterString)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals((Object)other.queueName)) {
            return false;
        }
        if (this.durable != other.durable) {
            return false;
        }
        if (this.routingType != other.routingType) {
            return false;
        }
        if (this.requiresResponse != other.requiresResponse) {
            return false;
        }
        if (this.maxConsumers == null ? other.maxConsumers != null : !this.maxConsumers.equals(other.maxConsumers)) {
            return false;
        }
        if (this.purgeOnNoConsumers == null ? other.purgeOnNoConsumers != null : !this.purgeOnNoConsumers.equals(other.purgeOnNoConsumers)) {
            return false;
        }
        if (this.exclusive == null ? other.exclusive != null : !this.exclusive.equals(other.exclusive)) {
            return false;
        }
        return !(this.lastValue == null ? other.lastValue != null : !this.lastValue.equals(other.lastValue));
    }
}

