/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandException;
import org.aesh.command.impl.internal.ParsedCommand;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.cli.AbstractDistributionCommand;
import org.jboss.as.patching.tool.PatchOperationBuilder;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.activator.AbstractCommandActivator;

public class PatchRollbackActivator
extends AbstractCommandActivator {
    public boolean isActivated(ParsedCommand command) {
        try {
            AbstractDistributionCommand cmd = (AbstractDistributionCommand)command.command();
            return !PatchRollbackActivator.getPatches(this.getCommandContext(), cmd, cmd.getPatchStream(), cmd.getHost()).isEmpty();
        }
        catch (Exception ex) {
            return true;
        }
    }

    private static List<ModelNode> getAllPatches(PatchOperationTarget target, String stream) throws PatchingException {
        if (stream == null) {
            PatchOperationBuilder streams = PatchOperationBuilder.Factory.streams();
            ModelNode response = streams.execute(target);
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return Collections.emptyList();
            }
            ArrayList<ModelNode> patches = new ArrayList<ModelNode>();
            List list = response.get("result").asList();
            for (ModelNode s : list) {
                patches.addAll(PatchRollbackActivator.getPatches(target, s.asString()));
            }
            return patches;
        }
        return PatchRollbackActivator.getPatches(target, stream);
    }

    private static List<ModelNode> getPatches(PatchOperationTarget target, String stream) throws PatchingException {
        PatchOperationBuilder history = PatchOperationBuilder.Factory.history(stream);
        ModelNode resp = history.execute(target);
        ModelNode res = resp.get("result");
        return res.asList();
    }

    static List<ModelNode> getPatches(CommandContext ctx, AbstractDistributionCommand cmd, String stream, String host) throws PatchingException, CommandException {
        if (ctx.isDomainMode()) {
            List<String> hosts = host == null ? Util.getHosts((ModelControllerClient)ctx.getModelControllerClient()) : Arrays.asList(host);
            ArrayList<ModelNode> patches = new ArrayList<ModelNode>();
            for (String h : hosts) {
                patches.addAll(PatchRollbackActivator.getAllPatches(PatchOperationTarget.createHost(h, ctx.getModelControllerClient()), null));
            }
            return patches;
        }
        return PatchRollbackActivator.getPatches(cmd.createPatchOperationTarget(ctx), stream);
    }
}

