/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.AbstractConfigVisitor;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class DefaultConfigVisitor
extends AbstractConfigVisitor {
    private final ServiceBuilder builder;
    private final BeanState state;
    private final Module module;
    private final DeploymentReflectionIndex index;
    private final BeanInfo beanInfo;

    public DefaultConfigVisitor(ServiceBuilder builder, BeanState state, Module module, DeploymentReflectionIndex index) {
        this(builder, state, module, index, null);
    }

    public DefaultConfigVisitor(ServiceBuilder builder, BeanState state, Module module, DeploymentReflectionIndex index, BeanInfo beanInfo) {
        this.builder = builder;
        this.state = state;
        this.module = module;
        this.index = index;
        this.beanInfo = beanInfo;
    }

    @Override
    public BeanState getState() {
        return this.state;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public Module loadModule(ModuleIdentifier identifier) {
        try {
            return this.module.getModule(identifier);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public DeploymentReflectionIndex getReflectionIndex() {
        return this.index;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public void addDependency(ServiceName name) {
        this.builder.addDependency(name);
    }

    @Override
    public void addDependency(ServiceName name, Injector injector) {
        this.builder.addDependency(name, injector);
    }

    @Override
    public void addDependency(String bean, BeanState state) {
        if (state != BeanState.DESCRIBED) {
            this.builder.addDependency(BeanMetaDataConfig.toBeanName(bean, BeanState.DESCRIBED));
        }
        this.builder.addDependency(BeanMetaDataConfig.toBeanName(bean, state));
    }

    @Override
    public void addDependency(String bean, BeanState state, Injector injector) {
        if (state != BeanState.DESCRIBED) {
            this.builder.addDependency(BeanMetaDataConfig.toBeanName(bean, BeanState.DESCRIBED));
        }
        this.builder.addDependency(BeanMetaDataConfig.toBeanName(bean, state), injector);
    }
}

