/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.SecurityActions;
import org.jboss.jca.core.spi.transaction.XAResourceStatistics;

public class PoolStatisticsImpl
implements PoolStatistics,
XAResourceStatistics {
    private static final long serialVersionUID = 9L;
    private static final String ACTIVE_COUNT = "ActiveCount";
    private static final String AVAILABLE_COUNT = "AvailableCount";
    private static final String AVERAGE_BLOCKING_TIME = "AverageBlockingTime";
    private static final String AVERAGE_CREATION_TIME = "AverageCreationTime";
    private static final String AVERAGE_GET_TIME = "AverageGetTime";
    private static final String AVERAGE_POOL_TIME = "AveragePoolTime";
    private static final String AVERAGE_USAGE_TIME = "AverageUsageTime";
    private static final String BLOCKING_FAILURE_COUNT = "BlockingFailureCount";
    private static final String CREATED_COUNT = "CreatedCount";
    private static final String DESTROYED_COUNT = "DestroyedCount";
    private static final String IDLE_COUNT = "IdleCount";
    private static final String IN_USE_COUNT = "InUseCount";
    private static final String MAX_CREATION_TIME = "MaxCreationTime";
    private static final String MAX_GET_TIME = "MaxGetTime";
    private static final String MAX_POOL_TIME = "MaxPoolTime";
    private static final String MAX_USAGE_TIME = "MaxUsageTime";
    private static final String MAX_USED_COUNT = "MaxUsedCount";
    private static final String MAX_WAIT_COUNT = "MaxWaitCount";
    private static final String MAX_WAIT_TIME = "MaxWaitTime";
    private static final String TIMED_OUT = "TimedOut";
    private static final String TOTAL_BLOCKING_TIME = "TotalBlockingTime";
    private static final String TOTAL_CREATION_TIME = "TotalCreationTime";
    private static final String TOTAL_GET_TIME = "TotalGetTime";
    private static final String TOTAL_POOL_TIME = "TotalPoolTime";
    private static final String TOTAL_USAGE_TIME = "TotalUsageTime";
    private static final String WAIT_COUNT = "WaitCount";
    private static final String XA_COMMIT_COUNT = "XACommitCount";
    private static final String XA_COMMIT_AVERAGE_TIME = "XACommitAverageTime";
    private static final String XA_COMMIT_TOTAL_TIME = "XACommitTotalTime";
    private static final String XA_COMMIT_MAX_TIME = "XACommitMaxTime";
    private static final String XA_END_COUNT = "XAEndCount";
    private static final String XA_END_AVERAGE_TIME = "XAEndAverageTime";
    private static final String XA_END_TOTAL_TIME = "XAEndTotalTime";
    private static final String XA_END_MAX_TIME = "XAEndMaxTime";
    private static final String XA_FORGET_COUNT = "XAForgetCount";
    private static final String XA_FORGET_AVERAGE_TIME = "XAForgetAverageTime";
    private static final String XA_FORGET_TOTAL_TIME = "XAForgetTotalTime";
    private static final String XA_FORGET_MAX_TIME = "XAForgetMaxTime";
    private static final String XA_PREPARE_COUNT = "XAPrepareCount";
    private static final String XA_PREPARE_AVERAGE_TIME = "XAPrepareAverageTime";
    private static final String XA_PREPARE_TOTAL_TIME = "XAPrepareTotalTime";
    private static final String XA_PREPARE_MAX_TIME = "XAPrepareMaxTime";
    private static final String XA_RECOVER_COUNT = "XARecoverCount";
    private static final String XA_RECOVER_AVERAGE_TIME = "XARecoverAverageTime";
    private static final String XA_RECOVER_TOTAL_TIME = "XARecoverTotalTime";
    private static final String XA_RECOVER_MAX_TIME = "XARecoverMaxTime";
    private static final String XA_ROLLBACK_COUNT = "XARollbackCount";
    private static final String XA_ROLLBACK_AVERAGE_TIME = "XARollbackAverageTime";
    private static final String XA_ROLLBACK_TOTAL_TIME = "XARollbackTotalTime";
    private static final String XA_ROLLBACK_MAX_TIME = "XARollbackMaxTime";
    private static final String XA_START_COUNT = "XAStartCount";
    private static final String XA_START_AVERAGE_TIME = "XAStartAverageTime";
    private static final String XA_START_TOTAL_TIME = "XAStartTotalTime";
    private static final String XA_START_MAX_TIME = "XAStartMaxTime";
    private int maxPoolSize;
    private transient SortedSet<String> names;
    private transient Map<String, Class> types;
    private transient Map<Locale, ResourceBundle> rbs;
    private transient AtomicBoolean enabled;
    private transient AtomicInteger createdCount;
    private transient AtomicInteger destroyedCount;
    private transient AtomicInteger maxUsedCount;
    private transient AtomicLong maxCreationTime;
    private transient AtomicLong maxGetTime;
    private transient AtomicLong maxPoolTime;
    private transient AtomicLong maxUsageTime;
    private transient AtomicInteger maxWaitCount;
    private transient AtomicLong maxWaitTime;
    private transient AtomicInteger timedOut;
    private transient AtomicLong totalBlockingTime;
    private transient AtomicLong totalBlockingTimeInvocations;
    private transient AtomicLong totalCreationTime;
    private transient AtomicLong totalGetTime;
    private transient AtomicLong totalGetTimeInvocations;
    private transient AtomicLong totalPoolTime;
    private transient AtomicLong totalPoolTimeInvocations;
    private transient AtomicLong totalUsageTime;
    private transient AtomicLong totalUsageTimeInvocations;
    private transient AtomicInteger inUseCount;
    private transient AtomicInteger blockingFailureCount;
    private transient AtomicInteger waitCount;
    private transient AtomicLong commitCount;
    private transient AtomicLong commitTotalTime;
    private transient AtomicLong commitMaxTime;
    private transient AtomicLong endCount;
    private transient AtomicLong endTotalTime;
    private transient AtomicLong endMaxTime;
    private transient AtomicLong forgetCount;
    private transient AtomicLong forgetTotalTime;
    private transient AtomicLong forgetMaxTime;
    private transient AtomicLong prepareCount;
    private transient AtomicLong prepareTotalTime;
    private transient AtomicLong prepareMaxTime;
    private transient AtomicLong recoverCount;
    private transient AtomicLong recoverTotalTime;
    private transient AtomicLong recoverMaxTime;
    private transient AtomicLong rollbackCount;
    private transient AtomicLong rollbackTotalTime;
    private transient AtomicLong rollbackMaxTime;
    private transient AtomicLong startCount;
    private transient AtomicLong startTotalTime;
    private transient AtomicLong startMaxTime;

    public PoolStatisticsImpl(int maxPoolSize) {
        this.init(maxPoolSize);
    }

    private void init(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.createdCount = new AtomicInteger(0);
        this.destroyedCount = new AtomicInteger(0);
        this.maxCreationTime = new AtomicLong(Long.MIN_VALUE);
        this.maxGetTime = new AtomicLong(Long.MIN_VALUE);
        this.maxPoolTime = new AtomicLong(Long.MIN_VALUE);
        this.maxUsageTime = new AtomicLong(Long.MIN_VALUE);
        this.maxUsedCount = new AtomicInteger(Integer.MIN_VALUE);
        this.maxWaitCount = new AtomicInteger(0);
        this.maxWaitTime = new AtomicLong(Long.MIN_VALUE);
        this.timedOut = new AtomicInteger(0);
        this.totalBlockingTime = new AtomicLong(0L);
        this.totalBlockingTimeInvocations = new AtomicLong(0L);
        this.totalCreationTime = new AtomicLong(0L);
        this.totalGetTime = new AtomicLong(0L);
        this.totalGetTimeInvocations = new AtomicLong(0L);
        this.totalPoolTime = new AtomicLong(0L);
        this.totalPoolTimeInvocations = new AtomicLong(0L);
        this.totalUsageTime = new AtomicLong(0L);
        this.totalUsageTimeInvocations = new AtomicLong(0L);
        this.inUseCount = new AtomicInteger(0);
        this.blockingFailureCount = new AtomicInteger(0);
        this.waitCount = new AtomicInteger(0);
        this.commitCount = new AtomicLong(0L);
        this.commitTotalTime = new AtomicLong(0L);
        this.commitMaxTime = new AtomicLong(0L);
        this.endCount = new AtomicLong(0L);
        this.endTotalTime = new AtomicLong(0L);
        this.endMaxTime = new AtomicLong(0L);
        this.forgetCount = new AtomicLong(0L);
        this.forgetTotalTime = new AtomicLong(0L);
        this.forgetMaxTime = new AtomicLong(0L);
        this.prepareCount = new AtomicLong(0L);
        this.prepareTotalTime = new AtomicLong(0L);
        this.prepareMaxTime = new AtomicLong(0L);
        this.recoverCount = new AtomicLong(0L);
        this.recoverTotalTime = new AtomicLong(0L);
        this.recoverMaxTime = new AtomicLong(0L);
        this.rollbackCount = new AtomicLong(0L);
        this.rollbackTotalTime = new AtomicLong(0L);
        this.rollbackMaxTime = new AtomicLong(0L);
        this.startCount = new AtomicLong(0L);
        this.startTotalTime = new AtomicLong(0L);
        this.startMaxTime = new AtomicLong(0L);
        TreeSet<String> n = new TreeSet<String>();
        HashMap<String, Class<Number>> t = new HashMap<String, Class<Number>>();
        n.add(ACTIVE_COUNT);
        t.put(ACTIVE_COUNT, Integer.TYPE);
        n.add(AVAILABLE_COUNT);
        t.put(AVAILABLE_COUNT, Integer.TYPE);
        n.add(AVERAGE_BLOCKING_TIME);
        t.put(AVERAGE_BLOCKING_TIME, Long.TYPE);
        n.add(AVERAGE_CREATION_TIME);
        t.put(AVERAGE_CREATION_TIME, Long.TYPE);
        n.add(AVERAGE_GET_TIME);
        t.put(AVERAGE_GET_TIME, Long.TYPE);
        n.add(AVERAGE_USAGE_TIME);
        t.put(AVERAGE_USAGE_TIME, Long.TYPE);
        n.add(AVERAGE_POOL_TIME);
        t.put(AVERAGE_POOL_TIME, Long.TYPE);
        n.add(BLOCKING_FAILURE_COUNT);
        t.put(BLOCKING_FAILURE_COUNT, Integer.TYPE);
        n.add(CREATED_COUNT);
        t.put(CREATED_COUNT, Integer.TYPE);
        n.add(DESTROYED_COUNT);
        t.put(DESTROYED_COUNT, Integer.TYPE);
        n.add(IDLE_COUNT);
        t.put(IDLE_COUNT, Integer.TYPE);
        n.add(IN_USE_COUNT);
        t.put(IN_USE_COUNT, Integer.TYPE);
        n.add(MAX_CREATION_TIME);
        t.put(MAX_CREATION_TIME, Long.TYPE);
        n.add(MAX_GET_TIME);
        t.put(MAX_GET_TIME, Long.TYPE);
        n.add(MAX_POOL_TIME);
        t.put(MAX_POOL_TIME, Long.TYPE);
        n.add(MAX_USAGE_TIME);
        t.put(MAX_USAGE_TIME, Long.TYPE);
        n.add(MAX_USED_COUNT);
        t.put(MAX_USED_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_COUNT);
        t.put(MAX_WAIT_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_TIME);
        t.put(MAX_WAIT_TIME, Long.TYPE);
        n.add(TIMED_OUT);
        t.put(TIMED_OUT, Integer.TYPE);
        n.add(TOTAL_BLOCKING_TIME);
        t.put(TOTAL_BLOCKING_TIME, Long.TYPE);
        n.add(TOTAL_CREATION_TIME);
        t.put(TOTAL_CREATION_TIME, Long.TYPE);
        n.add(TOTAL_GET_TIME);
        t.put(TOTAL_GET_TIME, Long.TYPE);
        n.add(TOTAL_POOL_TIME);
        t.put(TOTAL_POOL_TIME, Long.TYPE);
        n.add(TOTAL_USAGE_TIME);
        t.put(TOTAL_USAGE_TIME, Long.TYPE);
        n.add(WAIT_COUNT);
        t.put(WAIT_COUNT, Integer.TYPE);
        n.add(XA_COMMIT_COUNT);
        t.put(XA_COMMIT_COUNT, Long.TYPE);
        n.add(XA_COMMIT_AVERAGE_TIME);
        t.put(XA_COMMIT_AVERAGE_TIME, Long.TYPE);
        n.add(XA_COMMIT_TOTAL_TIME);
        t.put(XA_COMMIT_TOTAL_TIME, Long.TYPE);
        n.add(XA_COMMIT_MAX_TIME);
        t.put(XA_COMMIT_MAX_TIME, Long.TYPE);
        n.add(XA_END_COUNT);
        t.put(XA_END_COUNT, Long.TYPE);
        n.add(XA_END_AVERAGE_TIME);
        t.put(XA_END_AVERAGE_TIME, Long.TYPE);
        n.add(XA_END_TOTAL_TIME);
        t.put(XA_END_TOTAL_TIME, Long.TYPE);
        n.add(XA_END_MAX_TIME);
        t.put(XA_END_MAX_TIME, Long.TYPE);
        n.add(XA_FORGET_COUNT);
        t.put(XA_FORGET_COUNT, Long.TYPE);
        n.add(XA_FORGET_AVERAGE_TIME);
        t.put(XA_FORGET_AVERAGE_TIME, Long.TYPE);
        n.add(XA_FORGET_TOTAL_TIME);
        t.put(XA_FORGET_TOTAL_TIME, Long.TYPE);
        n.add(XA_FORGET_MAX_TIME);
        t.put(XA_FORGET_MAX_TIME, Long.TYPE);
        n.add(XA_PREPARE_COUNT);
        t.put(XA_PREPARE_COUNT, Long.TYPE);
        n.add(XA_PREPARE_AVERAGE_TIME);
        t.put(XA_PREPARE_AVERAGE_TIME, Long.TYPE);
        n.add(XA_PREPARE_TOTAL_TIME);
        t.put(XA_PREPARE_TOTAL_TIME, Long.TYPE);
        n.add(XA_PREPARE_MAX_TIME);
        t.put(XA_PREPARE_MAX_TIME, Long.TYPE);
        n.add(XA_RECOVER_COUNT);
        t.put(XA_RECOVER_COUNT, Long.TYPE);
        n.add(XA_RECOVER_AVERAGE_TIME);
        t.put(XA_RECOVER_AVERAGE_TIME, Long.TYPE);
        n.add(XA_RECOVER_TOTAL_TIME);
        t.put(XA_RECOVER_TOTAL_TIME, Long.TYPE);
        n.add(XA_RECOVER_MAX_TIME);
        t.put(XA_RECOVER_MAX_TIME, Long.TYPE);
        n.add(XA_ROLLBACK_COUNT);
        t.put(XA_ROLLBACK_COUNT, Long.TYPE);
        n.add(XA_ROLLBACK_AVERAGE_TIME);
        t.put(XA_ROLLBACK_AVERAGE_TIME, Long.TYPE);
        n.add(XA_ROLLBACK_TOTAL_TIME);
        t.put(XA_ROLLBACK_TOTAL_TIME, Long.TYPE);
        n.add(XA_ROLLBACK_MAX_TIME);
        t.put(XA_ROLLBACK_MAX_TIME, Long.TYPE);
        n.add(XA_START_COUNT);
        t.put(XA_START_COUNT, Long.TYPE);
        n.add(XA_START_AVERAGE_TIME);
        t.put(XA_START_AVERAGE_TIME, Long.TYPE);
        n.add(XA_START_TOTAL_TIME);
        t.put(XA_START_TOTAL_TIME, Long.TYPE);
        n.add(XA_START_MAX_TIME);
        t.put(XA_START_MAX_TIME, Long.TYPE);
        this.names = Collections.unmodifiableSortedSet(n);
        this.types = Collections.unmodifiableMap(t);
        this.enabled = new AtomicBoolean(true);
        ResourceBundle defaultResourceBundle = ResourceBundle.getBundle("poolstatistics", Locale.US, SecurityActions.getClassLoader(PoolStatisticsImpl.class));
        this.rbs = new HashMap<Locale, ResourceBundle>(1);
        this.rbs.put(Locale.US, defaultResourceBundle);
        this.clear();
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Class getType(String name) {
        return this.types.get(name);
    }

    public String getDescription(String name) {
        return this.getDescription(name, Locale.US);
    }

    public String getDescription(String name, Locale locale) {
        ResourceBundle newResourceBundle;
        ResourceBundle rb = this.rbs.get(locale);
        if (rb == null && (newResourceBundle = ResourceBundle.getBundle("poolstatistics", locale, SecurityActions.getClassLoader(PoolStatisticsImpl.class))) != null) {
            this.rbs.put(locale, newResourceBundle);
        }
        if (rb == null) {
            rb = this.rbs.get(Locale.US);
        }
        if (rb != null) {
            return rb.getString(name);
        }
        return "";
    }

    public Object getValue(String name) {
        if (ACTIVE_COUNT.equals(name)) {
            return this.getActiveCount();
        }
        if (AVAILABLE_COUNT.equals(name)) {
            return this.getAvailableCount();
        }
        if (AVERAGE_BLOCKING_TIME.equals(name)) {
            return this.getAverageBlockingTime();
        }
        if (AVERAGE_CREATION_TIME.equals(name)) {
            return this.getAverageCreationTime();
        }
        if (AVERAGE_GET_TIME.equals(name)) {
            return this.getAverageGetTime();
        }
        if (AVERAGE_USAGE_TIME.equals(name)) {
            return this.getAverageUsageTime();
        }
        if (AVERAGE_POOL_TIME.equals(name)) {
            return this.getAveragePoolTime();
        }
        if (BLOCKING_FAILURE_COUNT.equals(name)) {
            return this.getBlockingFailureCount();
        }
        if (CREATED_COUNT.equals(name)) {
            return this.getCreatedCount();
        }
        if (DESTROYED_COUNT.equals(name)) {
            return this.getDestroyedCount();
        }
        if (IDLE_COUNT.equals(name)) {
            return this.getIdleCount();
        }
        if (IN_USE_COUNT.equals(name)) {
            return this.getInUseCount();
        }
        if (MAX_CREATION_TIME.equals(name)) {
            return this.getMaxCreationTime();
        }
        if (MAX_GET_TIME.equals(name)) {
            return this.getMaxGetTime();
        }
        if (MAX_POOL_TIME.equals(name)) {
            return this.getMaxPoolTime();
        }
        if (MAX_USAGE_TIME.equals(name)) {
            return this.getMaxUsageTime();
        }
        if (MAX_USED_COUNT.equals(name)) {
            return this.getMaxUsedCount();
        }
        if (MAX_WAIT_COUNT.equals(name)) {
            return this.getMaxWaitCount();
        }
        if (MAX_WAIT_TIME.equals(name)) {
            return this.getMaxWaitTime();
        }
        if (TIMED_OUT.equals(name)) {
            return this.getTimedOut();
        }
        if (TOTAL_BLOCKING_TIME.equals(name)) {
            return this.getTotalBlockingTime();
        }
        if (TOTAL_CREATION_TIME.equals(name)) {
            return this.getTotalCreationTime();
        }
        if (TOTAL_GET_TIME.equals(name)) {
            return this.getTotalGetTime();
        }
        if (TOTAL_POOL_TIME.equals(name)) {
            return this.getTotalPoolTime();
        }
        if (TOTAL_USAGE_TIME.equals(name)) {
            return this.getTotalUsageTime();
        }
        if (WAIT_COUNT.equals(name)) {
            return this.getWaitCount();
        }
        if (XA_COMMIT_COUNT.equals(name)) {
            return this.getCommitCount();
        }
        if (XA_COMMIT_AVERAGE_TIME.equals(name)) {
            return this.getCommitAverageTime();
        }
        if (XA_COMMIT_TOTAL_TIME.equals(name)) {
            return this.getCommitTotalTime();
        }
        if (XA_COMMIT_MAX_TIME.equals(name)) {
            return this.getCommitMaxTime();
        }
        if (XA_END_COUNT.equals(name)) {
            return this.getEndCount();
        }
        if (XA_END_AVERAGE_TIME.equals(name)) {
            return this.getEndAverageTime();
        }
        if (XA_END_TOTAL_TIME.equals(name)) {
            return this.getEndTotalTime();
        }
        if (XA_END_MAX_TIME.equals(name)) {
            return this.getEndMaxTime();
        }
        if (XA_FORGET_COUNT.equals(name)) {
            return this.getForgetCount();
        }
        if (XA_FORGET_AVERAGE_TIME.equals(name)) {
            return this.getForgetAverageTime();
        }
        if (XA_FORGET_TOTAL_TIME.equals(name)) {
            return this.getForgetTotalTime();
        }
        if (XA_FORGET_MAX_TIME.equals(name)) {
            return this.getForgetMaxTime();
        }
        if (XA_PREPARE_COUNT.equals(name)) {
            return this.getPrepareCount();
        }
        if (XA_PREPARE_AVERAGE_TIME.equals(name)) {
            return this.getPrepareAverageTime();
        }
        if (XA_PREPARE_TOTAL_TIME.equals(name)) {
            return this.getPrepareTotalTime();
        }
        if (XA_PREPARE_MAX_TIME.equals(name)) {
            return this.getPrepareMaxTime();
        }
        if (XA_RECOVER_COUNT.equals(name)) {
            return this.getRecoverCount();
        }
        if (XA_RECOVER_AVERAGE_TIME.equals(name)) {
            return this.getRecoverAverageTime();
        }
        if (XA_RECOVER_TOTAL_TIME.equals(name)) {
            return this.getRecoverTotalTime();
        }
        if (XA_RECOVER_MAX_TIME.equals(name)) {
            return this.getRecoverMaxTime();
        }
        if (XA_ROLLBACK_COUNT.equals(name)) {
            return this.getRollbackCount();
        }
        if (XA_ROLLBACK_AVERAGE_TIME.equals(name)) {
            return this.getRollbackAverageTime();
        }
        if (XA_ROLLBACK_TOTAL_TIME.equals(name)) {
            return this.getRollbackTotalTime();
        }
        if (XA_ROLLBACK_MAX_TIME.equals(name)) {
            return this.getRollbackMaxTime();
        }
        if (XA_START_COUNT.equals(name)) {
            return this.getStartCount();
        }
        if (XA_START_AVERAGE_TIME.equals(name)) {
            return this.getStartAverageTime();
        }
        if (XA_START_TOTAL_TIME.equals(name)) {
            return this.getStartTotalTime();
        }
        if (XA_START_MAX_TIME.equals(name)) {
            return this.getStartMaxTime();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(boolean v) {
        if (this.enabled.get() != v) {
            this.enabled.set(v);
            this.clear();
        }
    }

    public int getActiveCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        if (this.createdCount.get() < this.destroyedCount.get()) {
            this.clear();
        }
        return this.createdCount.get() - this.destroyedCount.get();
    }

    public int getAvailableCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.maxPoolSize - this.inUseCount.get();
    }

    public long getAverageBlockingTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalBlockingTimeInvocations.get() != 0L ? this.totalBlockingTime.get() / this.totalBlockingTimeInvocations.get() : 0L;
    }

    public long getAverageCreationTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.createdCount.get() != 0 ? this.totalCreationTime.get() / (long)this.createdCount.get() : 0L;
    }

    public long getAverageGetTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalGetTimeInvocations.get() != 0L ? this.totalGetTime.get() / this.totalGetTimeInvocations.get() : 0L;
    }

    public long getAverageUsageTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalUsageTimeInvocations.get() != 0L ? this.totalUsageTime.get() / this.totalUsageTimeInvocations.get() : 0L;
    }

    public long getAveragePoolTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalPoolTimeInvocations.get() != 0L ? this.totalPoolTime.get() / this.totalPoolTimeInvocations.get() : 0L;
    }

    public int getBlockingFailureCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.blockingFailureCount.get();
    }

    public void deltaBlockingFailureCount() {
        if (this.enabled.get()) {
            this.blockingFailureCount.incrementAndGet();
        }
    }

    public int getCreatedCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.createdCount.get();
    }

    public void deltaCreatedCount() {
        if (this.enabled.get()) {
            this.createdCount.incrementAndGet();
        }
    }

    public int getDestroyedCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.destroyedCount.get();
    }

    public void deltaDestroyedCount() {
        if (this.enabled.get()) {
            this.destroyedCount.incrementAndGet();
        }
    }

    public int getIdleCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.getActiveCount() - this.getInUseCount();
    }

    public int getInUseCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.inUseCount.get();
    }

    public void setInUsedCount(int v) {
        this.inUseCount.set(v);
        this.setMaxUsedCount(v);
    }

    public int getMaxUsedCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.maxUsedCount.get() != Integer.MIN_VALUE ? this.maxUsedCount.get() : 0;
    }

    private void setMaxUsedCount(int v) {
        if (v > this.maxUsedCount.get()) {
            this.maxUsedCount.set(v);
        }
    }

    public long getMaxCreationTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxCreationTime.get() != Long.MIN_VALUE ? this.maxCreationTime.get() : 0L;
    }

    public long getMaxGetTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxGetTime.get() != Long.MIN_VALUE ? this.maxGetTime.get() : 0L;
    }

    public long getMaxPoolTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxPoolTime.get() != Long.MIN_VALUE ? this.maxPoolTime.get() : 0L;
    }

    public long getMaxUsageTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxUsageTime.get() != Long.MIN_VALUE ? this.maxUsageTime.get() : 0L;
    }

    public int getMaxWaitCount() {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.maxWaitCount.get() != Integer.MIN_VALUE ? this.maxWaitCount.get() : 0;
    }

    public void setMaxWaitCount(int v) {
        if (v > this.maxWaitCount.get()) {
            this.maxWaitCount.set(v);
        }
    }

    public long getMaxWaitTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxWaitTime.get() != Long.MIN_VALUE ? this.maxWaitTime.get() : 0L;
    }

    public int getTimedOut() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.timedOut.get();
    }

    public void deltaTimedOut() {
        if (this.enabled.get()) {
            this.timedOut.incrementAndGet();
        }
    }

    public long getTotalBlockingTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalBlockingTime.get();
    }

    public void deltaTotalBlockingTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalBlockingTime.addAndGet(delta);
            this.totalBlockingTimeInvocations.incrementAndGet();
            if (delta > this.maxWaitTime.get()) {
                this.maxWaitTime.set(delta);
            }
        }
    }

    public long getTotalCreationTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalCreationTime.get();
    }

    public void deltaTotalCreationTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalCreationTime.addAndGet(delta);
            if (delta > this.maxCreationTime.get()) {
                this.maxCreationTime.set(delta);
            }
        }
    }

    public long getTotalGetTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalGetTime.get();
    }

    public void deltaTotalGetTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalGetTime.addAndGet(delta);
            this.totalGetTimeInvocations.incrementAndGet();
            if (delta > this.maxGetTime.get()) {
                this.maxGetTime.set(delta);
            }
        }
    }

    public long getTotalPoolTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalPoolTime.get();
    }

    public void deltaTotalPoolTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalPoolTime.addAndGet(delta);
            this.totalPoolTimeInvocations.incrementAndGet();
            if (delta > this.maxPoolTime.get()) {
                this.maxPoolTime.set(delta);
            }
        }
    }

    public long getTotalUsageTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalUsageTime.get();
    }

    public void deltaTotalUsageTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalUsageTime.addAndGet(delta);
            this.totalUsageTimeInvocations.incrementAndGet();
            if (delta > this.maxUsageTime.get()) {
                this.maxUsageTime.set(delta);
            }
        }
    }

    public int getWaitCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.waitCount.get();
    }

    public void deltaWaitCount() {
        if (this.enabled.get()) {
            this.waitCount.incrementAndGet();
        }
    }

    public long getCommitCount() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.commitCount.get();
    }

    public long getCommitTotalTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.commitTotalTime.get();
    }

    public long getCommitAverageTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (this.commitCount.get() > 0L) {
            return this.commitTotalTime.get() / this.commitCount.get();
        }
        return 0L;
    }

    public long getCommitMaxTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.commitMaxTime.get();
    }

    public void deltaCommit(long time) {
        this.commitCount.incrementAndGet();
        if (time > 0L) {
            this.commitTotalTime.addAndGet(time);
            if (time > this.commitMaxTime.get()) {
                this.commitMaxTime.set(time);
            }
        }
    }

    public long getEndCount() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.endCount.get();
    }

    public long getEndTotalTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.endTotalTime.get();
    }

    public long getEndAverageTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (this.endCount.get() > 0L) {
            return this.endTotalTime.get() / this.endCount.get();
        }
        return 0L;
    }

    public long getEndMaxTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.endMaxTime.get();
    }

    public void deltaEnd(long time) {
        this.endCount.incrementAndGet();
        if (time > 0L) {
            this.endTotalTime.addAndGet(time);
            if (time > this.endMaxTime.get()) {
                this.endMaxTime.set(time);
            }
        }
    }

    public long getForgetCount() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.forgetCount.get();
    }

    public long getForgetTotalTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.forgetTotalTime.get();
    }

    public long getForgetAverageTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (this.forgetCount.get() > 0L) {
            return this.forgetTotalTime.get() / this.forgetCount.get();
        }
        return 0L;
    }

    public long getForgetMaxTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.forgetMaxTime.get();
    }

    public void deltaForget(long time) {
        this.forgetCount.incrementAndGet();
        if (time > 0L) {
            this.forgetTotalTime.addAndGet(time);
            if (time > this.forgetMaxTime.get()) {
                this.forgetMaxTime.set(time);
            }
        }
    }

    public long getPrepareCount() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.prepareCount.get();
    }

    public long getPrepareTotalTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.prepareTotalTime.get();
    }

    public long getPrepareAverageTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (this.prepareCount.get() > 0L) {
            return this.prepareTotalTime.get() / this.prepareCount.get();
        }
        return 0L;
    }

    public long getPrepareMaxTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.prepareMaxTime.get();
    }

    public void deltaPrepare(long time) {
        this.prepareCount.incrementAndGet();
        if (time > 0L) {
            this.prepareTotalTime.addAndGet(time);
            if (time > this.prepareMaxTime.get()) {
                this.prepareMaxTime.set(time);
            }
        }
    }

    public long getRecoverCount() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.recoverCount.get();
    }

    public long getRecoverTotalTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.recoverTotalTime.get();
    }

    public long getRecoverAverageTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (this.recoverCount.get() > 0L) {
            return this.recoverTotalTime.get() / this.recoverCount.get();
        }
        return 0L;
    }

    public long getRecoverMaxTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.recoverMaxTime.get();
    }

    public void deltaRecover(long time) {
        this.recoverCount.incrementAndGet();
        if (time > 0L) {
            this.recoverTotalTime.addAndGet(time);
            if (time > this.recoverMaxTime.get()) {
                this.recoverMaxTime.set(time);
            }
        }
    }

    public long getRollbackCount() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.rollbackCount.get();
    }

    public long getRollbackTotalTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.rollbackTotalTime.get();
    }

    public long getRollbackAverageTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (this.rollbackCount.get() > 0L) {
            return this.rollbackTotalTime.get() / this.rollbackCount.get();
        }
        return 0L;
    }

    public long getRollbackMaxTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.rollbackMaxTime.get();
    }

    public void deltaRollback(long time) {
        this.rollbackCount.incrementAndGet();
        if (time > 0L) {
            this.rollbackTotalTime.addAndGet(time);
            if (time > this.rollbackMaxTime.get()) {
                this.rollbackMaxTime.set(time);
            }
        }
    }

    public long getStartCount() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.startCount.get();
    }

    public long getStartTotalTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.startTotalTime.get();
    }

    public long getStartAverageTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        if (this.startCount.get() > 0L) {
            return this.startTotalTime.get() / this.startCount.get();
        }
        return 0L;
    }

    public long getStartMaxTime() {
        if (!this.isEnabled()) {
            return 0L;
        }
        return this.startMaxTime.get();
    }

    public void deltaStart(long time) {
        this.startCount.incrementAndGet();
        if (time > 0L) {
            this.startTotalTime.addAndGet(time);
            if (time > this.startMaxTime.get()) {
                this.startMaxTime.set(time);
            }
        }
    }

    public void clear() {
        this.createdCount.set(0);
        this.destroyedCount.set(0);
        this.maxCreationTime.set(Long.MIN_VALUE);
        this.maxGetTime.set(Long.MIN_VALUE);
        this.maxPoolTime.set(Long.MIN_VALUE);
        this.maxUsageTime.set(Long.MIN_VALUE);
        this.maxUsedCount.set(Integer.MIN_VALUE);
        this.maxWaitTime.set(Long.MIN_VALUE);
        this.timedOut.set(0);
        this.totalBlockingTime.set(0L);
        this.totalBlockingTimeInvocations.set(0L);
        this.totalCreationTime.set(0L);
        this.totalGetTime.set(0L);
        this.totalGetTimeInvocations.set(0L);
        this.totalPoolTime.set(0L);
        this.totalPoolTimeInvocations.set(0L);
        this.totalUsageTime.set(0L);
        this.totalUsageTimeInvocations.set(0L);
        this.inUseCount.set(0);
        this.blockingFailureCount.set(0);
        this.waitCount.set(0);
        this.commitCount = new AtomicLong(0L);
        this.commitTotalTime = new AtomicLong(0L);
        this.commitMaxTime = new AtomicLong(0L);
        this.endCount = new AtomicLong(0L);
        this.endTotalTime = new AtomicLong(0L);
        this.endMaxTime = new AtomicLong(0L);
        this.forgetCount = new AtomicLong(0L);
        this.forgetTotalTime = new AtomicLong(0L);
        this.forgetMaxTime = new AtomicLong(0L);
        this.prepareCount = new AtomicLong(0L);
        this.prepareTotalTime = new AtomicLong(0L);
        this.prepareMaxTime = new AtomicLong(0L);
        this.recoverCount = new AtomicLong(0L);
        this.recoverTotalTime = new AtomicLong(0L);
        this.recoverMaxTime = new AtomicLong(0L);
        this.rollbackCount = new AtomicLong(0L);
        this.rollbackTotalTime = new AtomicLong(0L);
        this.rollbackMaxTime = new AtomicLong(0L);
        this.startCount = new AtomicLong(0L);
        this.startTotalTime = new AtomicLong(0L);
        this.startMaxTime = new AtomicLong(0L);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.maxPoolSize);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init(in.readInt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolStatistics@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append("Enabled=").append(this.isEnabled());
        sb.append(",");
        sb.append(ACTIVE_COUNT).append("=").append(this.getActiveCount());
        sb.append(",");
        sb.append(AVAILABLE_COUNT).append("=").append(this.getAvailableCount());
        sb.append(",");
        sb.append(AVERAGE_BLOCKING_TIME).append("=").append(this.getAverageBlockingTime());
        sb.append(",");
        sb.append(AVERAGE_CREATION_TIME).append("=").append(this.getAverageCreationTime());
        sb.append(",");
        sb.append(AVERAGE_GET_TIME).append("=").append(this.getAverageGetTime());
        sb.append(",");
        sb.append(AVERAGE_POOL_TIME).append("=").append(this.getAveragePoolTime());
        sb.append(",");
        sb.append(AVERAGE_USAGE_TIME).append("=").append(this.getAverageUsageTime());
        sb.append(",");
        sb.append(BLOCKING_FAILURE_COUNT).append("=").append(this.getBlockingFailureCount());
        sb.append(",");
        sb.append(CREATED_COUNT).append("=").append(this.getCreatedCount());
        sb.append(",");
        sb.append(DESTROYED_COUNT).append("=").append(this.getDestroyedCount());
        sb.append(",");
        sb.append(IDLE_COUNT).append("=").append(this.getIdleCount());
        sb.append(",");
        sb.append(IN_USE_COUNT).append("=").append(this.getInUseCount());
        sb.append(",");
        sb.append(MAX_CREATION_TIME).append("=").append(this.getMaxCreationTime());
        sb.append(",");
        sb.append(MAX_GET_TIME).append("=").append(this.getMaxGetTime());
        sb.append(",");
        sb.append(MAX_POOL_TIME).append("=").append(this.getMaxPoolTime());
        sb.append(",");
        sb.append(MAX_USAGE_TIME).append("=").append(this.getMaxUsageTime());
        sb.append(",");
        sb.append(MAX_USED_COUNT).append("=").append(this.getMaxUsedCount());
        sb.append(",");
        sb.append(MAX_WAIT_COUNT).append("=").append(this.getMaxWaitCount());
        sb.append(",");
        sb.append(MAX_WAIT_TIME).append("=").append(this.getMaxWaitTime());
        sb.append(",");
        sb.append(TIMED_OUT).append("=").append(this.getTimedOut());
        sb.append(",");
        sb.append(TOTAL_BLOCKING_TIME).append("=").append(this.getTotalBlockingTime());
        sb.append(",");
        sb.append(TOTAL_CREATION_TIME).append("=").append(this.getTotalCreationTime());
        sb.append(",");
        sb.append(TOTAL_GET_TIME).append("=").append(this.getTotalGetTime());
        sb.append(",");
        sb.append(TOTAL_POOL_TIME).append("=").append(this.getTotalPoolTime());
        sb.append(",");
        sb.append(TOTAL_USAGE_TIME).append("=").append(this.getTotalUsageTime());
        sb.append(",");
        sb.append(WAIT_COUNT).append("=").append(this.getWaitCount());
        sb.append(",");
        sb.append(XA_COMMIT_COUNT).append("=").append(this.getCommitCount());
        sb.append(",");
        sb.append(XA_COMMIT_AVERAGE_TIME).append("=").append(this.getCommitAverageTime());
        sb.append(",");
        sb.append(XA_COMMIT_TOTAL_TIME).append("=").append(this.getCommitTotalTime());
        sb.append(",");
        sb.append(XA_COMMIT_MAX_TIME).append("=").append(this.getCommitMaxTime());
        sb.append(",");
        sb.append(XA_END_COUNT).append("=").append(this.getEndCount());
        sb.append(",");
        sb.append(XA_END_AVERAGE_TIME).append("=").append(this.getEndAverageTime());
        sb.append(",");
        sb.append(XA_END_TOTAL_TIME).append("=").append(this.getEndTotalTime());
        sb.append(",");
        sb.append(XA_END_MAX_TIME).append("=").append(this.getEndMaxTime());
        sb.append(",");
        sb.append(XA_FORGET_COUNT).append("=").append(this.getForgetCount());
        sb.append(",");
        sb.append(XA_FORGET_AVERAGE_TIME).append("=").append(this.getForgetAverageTime());
        sb.append(",");
        sb.append(XA_FORGET_TOTAL_TIME).append("=").append(this.getForgetTotalTime());
        sb.append(",");
        sb.append(XA_FORGET_MAX_TIME).append("=").append(this.getForgetMaxTime());
        sb.append(",");
        sb.append(XA_PREPARE_COUNT).append("=").append(this.getPrepareCount());
        sb.append(",");
        sb.append(XA_PREPARE_AVERAGE_TIME).append("=").append(this.getPrepareAverageTime());
        sb.append(",");
        sb.append(XA_PREPARE_TOTAL_TIME).append("=").append(this.getPrepareTotalTime());
        sb.append(",");
        sb.append(XA_PREPARE_MAX_TIME).append("=").append(this.getPrepareMaxTime());
        sb.append(",");
        sb.append(XA_RECOVER_COUNT).append("=").append(this.getRecoverCount());
        sb.append(",");
        sb.append(XA_RECOVER_AVERAGE_TIME).append("=").append(this.getRecoverAverageTime());
        sb.append(",");
        sb.append(XA_RECOVER_TOTAL_TIME).append("=").append(this.getRecoverTotalTime());
        sb.append(",");
        sb.append(XA_RECOVER_MAX_TIME).append("=").append(this.getRecoverMaxTime());
        sb.append(",");
        sb.append(XA_ROLLBACK_COUNT).append("=").append(this.getRollbackCount());
        sb.append(",");
        sb.append(XA_ROLLBACK_AVERAGE_TIME).append("=").append(this.getRollbackAverageTime());
        sb.append(",");
        sb.append(XA_ROLLBACK_TOTAL_TIME).append("=").append(this.getRollbackTotalTime());
        sb.append(",");
        sb.append(XA_ROLLBACK_MAX_TIME).append("=").append(this.getRollbackMaxTime());
        sb.append(",");
        sb.append(XA_START_COUNT).append("=").append(this.getStartCount());
        sb.append(",");
        sb.append(XA_START_AVERAGE_TIME).append("=").append(this.getStartAverageTime());
        sb.append(",");
        sb.append(XA_START_TOTAL_TIME).append("=").append(this.getStartTotalTime());
        sb.append(",");
        sb.append(XA_START_MAX_TIME).append("=").append(this.getStartMaxTime());
        sb.append("]");
        return sb.toString();
    }
}

