/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.tracerresolver;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.PriorityComparator;
import io.opentracing.contrib.tracerresolver.TracerConverter;
import io.opentracing.contrib.tracerresolver.TracerFactory;
import io.opentracing.util.GlobalTracer;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TracerResolver {
    private static final Logger LOGGER = Logger.getLogger(TracerResolver.class.getName());

    @Deprecated
    protected abstract Tracer resolve();

    public static Tracer resolveTracer() {
        try {
            if (GlobalTracer.isRegistered()) {
                return TracerResolver.logResolved(GlobalTracer.get());
            }
        }
        catch (NoClassDefFoundError globalTracerNotInClasspath) {
            LOGGER.finest("GlobalTracer is not found on the classpath.");
        }
        Tracer tracer = null;
        if (!TracerResolver.isDisabled()) {
            tracer = TracerResolver.getFromFactory();
            if (null == tracer) {
                tracer = TracerResolver.getFromResolver();
            }
            if (null == tracer) {
                tracer = TracerResolver.getFromServiceLoader();
            }
        }
        return tracer;
    }

    @Deprecated
    public static void reload() {
        LOGGER.log(Level.FINER, "No-op for this implementation.");
    }

    private static boolean isDisabled() {
        String prop = System.getProperty("tracerresolver.disabled", System.getenv("TRACERRESOLVER_DISABLED"));
        return prop != null && (prop.equals("1") || prop.equalsIgnoreCase("true"));
    }

    private static Tracer convert(Tracer resolved) {
        if (resolved != null) {
            for (TracerConverter converter : PriorityComparator.prioritize(ServiceLoader.load(TracerConverter.class))) {
                try {
                    Tracer converted = converter.convert(resolved);
                    LOGGER.log(Level.FINEST, "Converted {0} using {1}: {2}.", new Object[]{resolved, converter, converted});
                    resolved = converted;
                }
                catch (RuntimeException rte) {
                    LOGGER.log(Level.WARNING, "Error converting " + resolved + " with " + converter + ": " + rte.getMessage(), rte);
                }
                if (resolved != null) continue;
                break;
            }
        }
        return resolved;
    }

    private static Tracer logResolved(Tracer resolvedTracer) {
        LOGGER.log(Level.FINER, "Resolved tracer: {0}.", resolvedTracer);
        return resolvedTracer;
    }

    private static Tracer getFromFactory() {
        for (TracerFactory factory : PriorityComparator.prioritize(ServiceLoader.load(TracerFactory.class))) {
            try {
                Tracer tracer = TracerResolver.convert(factory.getTracer());
                if (tracer == null) continue;
                return TracerResolver.logResolved(tracer);
            }
            catch (RuntimeException rte) {
                LOGGER.log(Level.WARNING, "Error getting tracer using " + factory + ": " + rte.getMessage(), rte);
            }
        }
        return null;
    }

    private static Tracer getFromResolver() {
        for (TracerResolver resolver : PriorityComparator.prioritize(ServiceLoader.load(TracerResolver.class))) {
            try {
                Tracer tracer = TracerResolver.convert(resolver.resolve());
                if (tracer == null) continue;
                return TracerResolver.logResolved(tracer);
            }
            catch (RuntimeException rte) {
                LOGGER.log(Level.WARNING, "Error resolving tracer using " + resolver + ": " + rte.getMessage(), rte);
            }
        }
        return null;
    }

    private static Tracer getFromServiceLoader() {
        for (Tracer tracer : PriorityComparator.prioritize(ServiceLoader.load(Tracer.class))) {
            if ((tracer = TracerResolver.convert(tracer)) == null) continue;
            return TracerResolver.logResolved(tracer);
        }
        return null;
    }
}

