/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.DataSourceConnectionFactoryConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class JDBCStoreServiceConfigurator
extends StoreServiceConfigurator<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder> {
    private final SupplierDependency<TableManipulationConfiguration> table;
    private volatile SupplierDependency<Module> module;
    private volatile SupplierDependency<DataSource> dataSource;
    private volatile DatabaseType dialect;

    JDBCStoreServiceConfigurator(PathAddress address) {
        super(address, JdbcStringBasedStoreConfigurationBuilder.class);
        PathAddress cacheAddress = address.getParent();
        PathAddress containerAddress = cacheAddress.getParent();
        this.table = new ServiceSupplierDependency(CacheComponent.STRING_TABLE.getServiceName(cacheAddress));
        this.module = new ServiceSupplierDependency(CacheContainerComponent.MODULE.getServiceName(containerAddress));
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(new CompositeDependency(new Dependency[]{this.table, this.module, this.dataSource}).register(builder));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String dataSource = JDBCStoreResourceDefinition.Attribute.DATA_SOURCE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.dataSource = new ServiceSupplierDependency(CommonUnaryRequirement.DATA_SOURCE.getServiceName(context, dataSource));
        this.dialect = ModelNodes.optionalEnum((ModelNode)JDBCStoreResourceDefinition.Attribute.DIALECT.resolveModelAttribute((ExpressionResolver)context, model), DatabaseType.class).orElse(null);
        return super.configure(context, model);
    }

    @Override
    public void accept(JdbcStringBasedStoreConfigurationBuilder builder) {
        builder.table().read((TableManipulationConfiguration)this.table.get());
        Iterator<TwoWayKey2StringMapper> iterator = ServiceLoader.load(TwoWayKey2StringMapper.class, (ClassLoader)((Module)this.module.get()).getClassLoader()).iterator();
        if (iterator.hasNext()) {
            TwoWayKey2StringMapper mapper = iterator.next();
            builder.key2StringMapper(mapper.getClass());
        }
        ((DataSourceConnectionFactoryConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.dialect(this.dialect)).connectionFactory(DataSourceConnectionFactoryConfigurationBuilder.class)).setDataSourceDependency((Supplier<DataSource>)this.dataSource);
    }
}

