/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.security.PrivilegedAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ScheduledThreadPoolServiceConfigurator
extends GlobalComponentServiceConfigurator<ThreadPoolConfiguration> {
    static final PrivilegedAction<ClassLoader> GET_CLASS_LOADER_ACTION = () -> ThreadPoolExecutorFactory.class.getClassLoader();
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ScheduledThreadPoolDefinition definition;

    ScheduledThreadPoolServiceConfigurator(ScheduledThreadPoolDefinition definition, PathAddress address) {
        super(definition, address);
        this.definition = definition;
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final int maxThreads = this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final long keepAliveTime = this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong();
        ThreadPoolExecutorFactory<ScheduledExecutorService> factory = new ThreadPoolExecutorFactory<ScheduledExecutorService>(){

            public ScheduledExecutorService createExecutor(ThreadFactory factory) {
                ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(maxThreads, (ThreadFactory)new ClassLoaderThreadFactory(factory, (ClassLoader)WildFlySecurityManager.doUnchecked(GET_CLASS_LOADER_ACTION)));
                executor.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
                executor.setRemoveOnCancelPolicy(true);
                executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                return executor;
            }

            public void validate() {
            }
        };
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        return this;
    }

    @Override
    public ThreadPoolConfiguration get() {
        return this.builder.create();
    }
}

