/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

class PathContentServitor
extends AbstractService<VirtualFile> {
    private final String unresolvedPath;
    private final String relativeTo;
    private final InjectedValue<PathManager> pathManagerValue = new InjectedValue();
    private volatile PathManager.Callback.Handle callbackHandle;

    static ServiceController<VirtualFile> addService(OperationContext context, ServiceTarget serviceTarget, ServiceName serviceName, String path, String relativeTo) {
        PathContentServitor service = new PathContentServitor(path, relativeTo);
        return serviceTarget.addService(serviceName, (Service)service).addDependency(context.getCapabilityServiceName("org.wildfly.management.path-manager", PathManager.class), PathManager.class, service.pathManagerValue).install();
    }

    private PathContentServitor(String relativePath, String relativeTo) {
        this.unresolvedPath = relativePath;
        this.relativeTo = relativeTo;
    }

    public VirtualFile getValue() throws IllegalStateException, IllegalArgumentException {
        return VFS.getChild((String)this.resolvePath());
    }

    private String resolvePath() {
        return ((PathManager)this.pathManagerValue.getValue()).resolveRelativePathEntry(this.unresolvedPath, this.relativeTo);
    }

    public void start(StartContext context) throws StartException {
        super.start(context);
        if (this.relativeTo != null) {
            this.callbackHandle = ((PathManager)this.pathManagerValue.getValue()).registerCallback(this.relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
        }
    }

    public void stop(StopContext context) {
        super.stop(context);
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
        }
    }
}

