/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.logging;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.infinispan.notifications.cachelistener.event.Event;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;
import org.wildfly.clustering.group.Node;

@MessageLogger(projectCode="WFLYCLSV", length=4)
public interface ClusteringServerLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.wildfly.clustering.server";
    public static final ClusteringServerLogger ROOT_LOGGER = (ClusteringServerLogger)Logger.getMessageLogger(ClusteringServerLogger.class, (String)"org.wildfly.clustering.server");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="This node will now operate as the singleton provider of the %s service")
    public void startSingleton(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="This node will no longer operate as the singleton provider of the %s service")
    public void stopSingleton(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="%s elected as the singleton provider of the %s service")
    public void elected(String var1, String var2);

    @Message(id=4, value="No response received from master node of the %s service, retrying...")
    public IllegalStateException noResponseFromMaster(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Failed to start %s service")
    public void serviceStartFailed(@Cause StartException var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Failed to reach quorum of %2$d for %1$s service. No singleton master will be elected.")
    public void quorumNotReached(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.")
    public void quorumJustReached(String var1, int var2);

    @Message(id=8, value="Detected multiple primary providers for %s service: %s")
    public IllegalArgumentException multiplePrimaryProvidersDetected(String var1, Collection<Node> var2);

    @Message(id=9, value="Singleton service %s is not started.")
    public IllegalStateException notStarted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Failed to purge %s/%s registry of old registry entries for: %s")
    public void registryPurgeFailed(@Cause Throwable var1, String var2, String var3, Collection<?> var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Failed to notify %s/%s registry listener of %s(%s) event")
    public void registryListenerFailed(@Cause Throwable var1, String var2, String var3, Event.Type var4, Map<?, ?> var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Failed to notify %s/%s service provider registration listener of new providers: %s")
    public void serviceProviderRegistrationListenerFailed(@Cause Throwable var1, String var2, String var3, Set<Node> var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="No node was elected as the singleton provider of the %s service")
    public void noPrimaryElected(String var1);

    @Message(id=14, value="Specified quorum %d must be greater than zero")
    public IllegalArgumentException invalidQuorum(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Failed to restore local %s/%s registry entry following network partititon merge")
    public void failedToRestoreLocalRegistryEntry(@Cause Throwable var1, String var2, String var3);

    @Message(id=16, value="A command dispatcher already exists for %s")
    public IllegalArgumentException commandDispatcherAlreadyExists(Object var1);

    @Message(id=17, value="A command dispatcher for %s already exists, but with a different command context")
    public IllegalArgumentException commandDispatcherContextMismatch(Object var1);
}

