/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ScaleDownAttributes {
    private static final String SCALE_DOWN_DISCOVERY_GROUP_STR = "scale-down-discovery-group";
    private static final String SCALE_DOWN_CONNECTORS_STR = "scale-down-connectors";
    public static final SimpleAttributeDefinition SCALE_DOWN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down", (ModelType)ModelType.BOOLEAN).setAttributeGroup("scale-down")).setXmlName("enabled")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SCALE_DOWN_CLUSTER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down-cluster-name", (ModelType)ModelType.STRING).setAttributeGroup("scale-down")).setXmlName("cluster-name")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SCALE_DOWN_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down-group-name", (ModelType)ModelType.STRING).setAttributeGroup("scale-down")).setXmlName("group-name")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SCALE_DOWN_DISCOVERY_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down-discovery-group", (ModelType)ModelType.STRING).setAttributeGroup("scale-down")).setXmlName("discovery-group")).setRequired(false)).setAlternatives(new String[]{"scale-down-connectors"})).setRestartAllServices()).build();
    public static final AttributeDefinition SCALE_DOWN_CONNECTORS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("scale-down-connectors").setAttributeGroup("scale-down")).setXmlName("connectors")).setAlternatives(new String[]{"scale-down-discovery-group"})).setRequired(false)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setAttributeParser(AttributeParser.STRING_LIST)).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> SCALE_DOWN_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(SCALE_DOWN, SCALE_DOWN_CLUSTER_NAME, SCALE_DOWN_GROUP_NAME, SCALE_DOWN_DISCOVERY_GROUP, SCALE_DOWN_CONNECTORS));

    static ScaleDownConfiguration addScaleDownConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode connectors;
        ModelNode discoveryGroupName;
        ModelNode groupName;
        if (!model.hasDefined(SCALE_DOWN.getName())) {
            return null;
        }
        ScaleDownConfiguration scaleDownConfiguration = new ScaleDownConfiguration();
        scaleDownConfiguration.setEnabled(SCALE_DOWN.resolveModelAttribute(context, model).asBoolean());
        ModelNode clusterName = SCALE_DOWN_CLUSTER_NAME.resolveModelAttribute(context, model);
        if (clusterName.isDefined()) {
            scaleDownConfiguration.setClusterName(clusterName.asString());
        }
        if ((groupName = SCALE_DOWN_GROUP_NAME.resolveModelAttribute(context, model)).isDefined()) {
            scaleDownConfiguration.setGroupName(groupName.asString());
        }
        if ((discoveryGroupName = SCALE_DOWN_DISCOVERY_GROUP.resolveModelAttribute(context, model)).isDefined()) {
            scaleDownConfiguration.setDiscoveryGroup(discoveryGroupName.asString());
        }
        if ((connectors = SCALE_DOWN_CONNECTORS.resolveModelAttribute(context, model)).isDefined()) {
            ArrayList connectorNames = new ArrayList(connectors.keys());
            scaleDownConfiguration.setConnectors(connectorNames);
        }
        return scaleDownConfiguration;
    }
}

