/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.agroal.pool.util.ListenerHelper;
import io.agroal.pool.util.PropertyInjector;
import io.agroal.pool.util.XAConnectionAdaptor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public final class ConnectionFactory {
    private static final String URL_PROPERTY_NAME = "url";
    private static final String USER_PROPERTY_NAME = "user";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private final AgroalConnectionFactoryConfiguration configuration;
    private final AgroalDataSourceListener[] listeners;
    private final Properties jdbcProperties;
    private final Mode factoryMode;
    private Driver driver;
    private DataSource dataSource;
    private XADataSource xaDataSource;

    public ConnectionFactory(AgroalConnectionFactoryConfiguration configuration, AgroalDataSourceListener ... listeners) {
        this.configuration = configuration;
        this.listeners = listeners;
        this.jdbcProperties = new Properties();
        configuration.jdbcProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this.jdbcProperties::put));
        this.setupSecurity(configuration);
        this.factoryMode = Mode.fromClass(configuration.connectionProviderClass());
        switch (this.factoryMode) {
            case XA_DATASOURCE: {
                this.setupXA();
                break;
            }
            case DATASOURCE: {
                this.setupDataSource();
                break;
            }
            case DRIVER: {
                this.setupDriver();
            }
        }
    }

    private void setupXA() {
        try {
            this.xaDataSource = this.configuration.connectionProviderClass().asSubclass(XADataSource.class).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate XADataSource", e);
        }
        PropertyInjector injector = new PropertyInjector(this.configuration.connectionProviderClass());
        if (this.configuration.jdbcUrl() != null && !this.configuration.jdbcUrl().isEmpty()) {
            this.injectProperty(injector, this.xaDataSource, URL_PROPERTY_NAME, this.configuration.jdbcUrl());
        }
        this.injectJdbcProperties(injector, this.xaDataSource);
    }

    private void setupDataSource() {
        try {
            this.dataSource = this.configuration.connectionProviderClass().asSubclass(DataSource.class).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate DataSource", e);
        }
        PropertyInjector injector = new PropertyInjector(this.configuration.connectionProviderClass());
        if (this.configuration.jdbcUrl() != null && !this.configuration.jdbcUrl().isEmpty()) {
            this.injectProperty(injector, this.dataSource, URL_PROPERTY_NAME, this.configuration.jdbcUrl());
        }
        this.injectJdbcProperties(injector, this.dataSource);
    }

    private void setupDriver() {
        if (this.configuration.connectionProviderClass() == null) {
            try {
                this.driver = DriverManager.getDriver(this.configuration.jdbcUrl());
            }
            catch (SQLException sql) {
                throw new RuntimeException("Unable to get java.sql.Driver from DriverManager", sql);
            }
        }
        try {
            this.driver = this.configuration.connectionProviderClass().asSubclass(Driver.class).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate java.sql.Driver", e);
        }
    }

    private void injectProperty(PropertyInjector injector, Object target, String propertyName, String propertyValue) {
        try {
            injector.inject(target, propertyName, propertyValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            ListenerHelper.fireOnWarning(this.listeners, "Ignoring property '" + propertyName + "': " + e.getMessage());
        }
    }

    private void injectJdbcProperties(PropertyInjector injector, Object target) {
        boolean ignoring = false;
        for (String propertyName : this.jdbcProperties.stringPropertyNames()) {
            try {
                injector.inject(target, propertyName, this.jdbcProperties.getProperty(propertyName));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                ListenerHelper.fireOnWarning(this.listeners, "Ignoring property '" + propertyName + "': " + e.getMessage());
                ignoring = true;
            }
        }
        if (ignoring) {
            ListenerHelper.fireOnWarning(this.listeners, "Available properties " + Arrays.toString(injector.availableProperties().toArray()));
        }
    }

    private void setupSecurity(AgroalConnectionFactoryConfiguration configuration) {
        Principal principal = configuration.principal();
        if (principal != null) {
            if (principal instanceof NamePrincipal) {
                this.jdbcProperties.put(USER_PROPERTY_NAME, principal.getName());
            } else {
                throw new IllegalArgumentException("Unknown Principal type: " + principal.getClass().getName());
            }
        }
        for (Object credential : configuration.credentials()) {
            if (credential instanceof SimplePassword) {
                this.jdbcProperties.put(PASSWORD_PROPERTY_NAME, ((SimplePassword)credential).getWord());
                continue;
            }
            throw new IllegalArgumentException("Unknown Credential type: " + credential.getClass().getName());
        }
    }

    public XAConnection createConnection() throws SQLException {
        switch (this.factoryMode) {
            case DRIVER: {
                return new XAConnectionAdaptor(this.connectionSetup(this.driver.connect(this.configuration.jdbcUrl(), this.jdbcProperties)));
            }
            case DATASOURCE: {
                return new XAConnectionAdaptor(this.connectionSetup(this.dataSource.getConnection()));
            }
            case XA_DATASOURCE: {
                return this.xaConnectionSetup(this.xaDataSource.getXAConnection());
            }
        }
        throw new SQLException("Unknown connection factory mode");
    }

    private Connection connectionSetup(Connection connection) throws SQLException {
        connection.setAutoCommit(this.configuration.autoCommit());
        if (this.configuration.jdbcTransactionIsolation().isDefined()) {
            connection.setTransactionIsolation(this.configuration.jdbcTransactionIsolation().level());
        }
        if (this.configuration.initialSql() != null && !this.configuration.initialSql().isEmpty()) {
            try (Statement statement = connection.createStatement();){
                statement.execute(this.configuration.initialSql());
            }
        }
        return connection;
    }

    private XAConnection xaConnectionSetup(XAConnection xaConnection) throws SQLException {
        if (xaConnection.getXAResource() == null) {
            throw new SQLException("null XAResource from XADataSource");
        }
        this.connectionSetup(xaConnection.getConnection());
        return xaConnection;
    }

    private static enum Mode {
        DRIVER,
        DATASOURCE,
        XA_DATASOURCE;


        private static Mode fromClass(Class<?> providerClass) {
            if (providerClass == null) {
                return DRIVER;
            }
            if (XADataSource.class.isAssignableFrom(providerClass)) {
                return XA_DATASOURCE;
            }
            if (DataSource.class.isAssignableFrom(providerClass)) {
                return DATASOURCE;
            }
            if (Driver.class.isAssignableFrom(providerClass)) {
                return DRIVER;
            }
            throw new IllegalArgumentException("Unable to create ConnectionFactory from providerClass " + providerClass.getName());
        }
    }
}

