/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.stspool;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.bindings.stspool.STSConfigData;
import org.picketlink.identity.federation.bindings.util.ModuleUtils;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientConfigKeyProvider;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;

class STSClientPoolInternal {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    static int DEFAULT_NUM_STS_CLIENTS = 10;
    private Hashtable<String, ArrayList<STSClient>> free = new Hashtable();
    private Hashtable<String, ArrayList<STSClient>> inUse = new Hashtable();
    private Hashtable<String, STSConfigData> configs = new Hashtable();

    STSClientPoolInternal() {
    }

    void initialize(int numberOfSTSClients, STSClientConfig stsClientConfig) {
        this.internalInitialize(numberOfSTSClients, stsClientConfig, null);
    }

    void initialize(STSClientConfig stsClientConfig) {
        this.internalInitialize(DEFAULT_NUM_STS_CLIENTS, stsClientConfig, null);
    }

    void initialize(int numberOfSTSClients, STSClientCreationCallBack clientCreationCallBack) {
        this.internalInitialize(numberOfSTSClients, null, clientCreationCallBack);
    }

    private synchronized void internalInitialize(int numberOfSTSClients, STSClientConfig stsClientConfig, STSClientCreationCallBack clientCreationCallBack) {
        STSConfigData configData;
        ArrayList<STSClient> clients;
        if (numberOfSTSClients <= 0) {
            return;
        }
        String key = null;
        key = clientCreationCallBack != null ? this.substituteKey(clientCreationCallBack.getKey()) : this.key(stsClientConfig);
        if (!this.configs.containsKey(key)) {
            int i;
            clients = new ArrayList<STSClient>(numberOfSTSClients);
            if (clientCreationCallBack != null) {
                for (i = 0; i < numberOfSTSClients; ++i) {
                    clients.add(clientCreationCallBack.createClient());
                }
            } else {
                for (i = 0; i < numberOfSTSClients; ++i) {
                    clients.add(new STSClient(stsClientConfig));
                }
            }
            configData = new STSConfigData();
            configData.initialNumberOfClients = numberOfSTSClients;
            if (clientCreationCallBack != null) {
                configData.config = null;
                configData.callBack = clientCreationCallBack;
            } else {
                configData.config = stsClientConfig;
                configData.callBack = null;
            }
        } else {
            throw logger.freePoolAlreadyContainsGivenKey(key);
        }
        this.configs.put(key, configData);
        this.free.put(key, clients);
        this.inUse.put(key, new ArrayList(numberOfSTSClients));
    }

    synchronized void destroy(STSClientConfig stsClientConfig) {
        String key = this.key(stsClientConfig);
        this.free.remove(key);
        this.inUse.remove(key);
        this.configs.remove(key);
    }

    synchronized void destroy(String moduleName) {
        String module = moduleName;
        if (moduleName == null || moduleName.isEmpty()) {
            module = ModuleUtils.getCurrentModuleId();
        }
        int removed = 0;
        this.removeByPrefix(module, this.free);
        this.removeByPrefix(module, this.inUse);
        if ((removed += this.removeByPrefix(module, this.configs)) == 0) {
            module = "deployment." + module;
            this.removeByPrefix(module, this.free);
            this.removeByPrefix(module, this.inUse);
            this.removeByPrefix(module, this.configs);
        }
    }

    STSClient takeOut(STSClientConfig stsClientConfig) {
        String key = this.key(stsClientConfig);
        return this.takeOutInternal(key);
    }

    STSClient takeOut(String key) {
        String substKey = this.substituteKey(key);
        STSClient client = this.takeOutInternal(substKey);
        if (client == null) {
            STSConfigData configData = this.configs.get(substKey);
            if (configData == null) {
                throw logger.cannotGetSTSConfigByKey(substKey);
            }
            if (configData.callBack != null) {
                this.internalInitialize(DEFAULT_NUM_STS_CLIENTS, null, configData.callBack);
            } else if (configData.config != null) {
                this.internalInitialize(DEFAULT_NUM_STS_CLIENTS, configData.config, configData.callBack);
            }
            client = this.takeOutInternal(substKey);
        }
        return client;
    }

    boolean isConfigInitialized(STSClientConfig stsClientConfig) {
        if (stsClientConfig == null) {
            return false;
        }
        STSConfigData configData = this.configs.get(this.key(stsClientConfig));
        return configData != null;
    }

    boolean isConfigInitialized(String key) {
        if (key == null) {
            return false;
        }
        STSConfigData configData = this.configs.get(this.substituteKey(key));
        return configData != null;
    }

    void putIn(STSClientConfigKeyProvider keyProvider, STSClient client) {
        this.putInInternal(this.substituteKey(keyProvider.getSTSClientConfigKey()), client);
    }

    void putIn(String key, STSClient client) {
        this.putInInternal(this.substituteKey(key), client);
    }

    void putIn(STSClient client) {
        this.putInInternal(this.substituteKey(client.getSTSClientConfigKey()), client);
    }

    private synchronized STSClient takeOutInternal(String key) {
        ArrayList<STSClient> clients = this.free.get(key);
        if (clients != null) {
            STSClient client;
            int size = clients.size();
            if (size > 0) {
                client = clients.remove(size - 1);
            } else {
                this.addClients(key);
                client = clients.remove(clients.size() - 1);
            }
            this.markInUse(key, client);
            return client;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addClients(String key) {
        STSConfigData configData = this.configs.get(key);
        if (configData == null) throw logger.cannotGetSTSConfigByKey(key);
        ArrayList<STSClient> freeClientPool = this.free.get(key);
        if (freeClientPool == null) throw logger.cannotGetFreeClientPoolKey(key);
        ArrayList<STSClient> clients = new ArrayList<STSClient>(configData.initialNumberOfClients);
        if (configData.config != null) {
            for (int i = 0; i < configData.initialNumberOfClients; ++i) {
                clients.add(new STSClient(configData.config));
            }
        } else {
            for (int i = 0; i < configData.initialNumberOfClients; ++i) {
                clients.add(configData.callBack.createClient());
            }
        }
        freeClientPool.addAll(clients);
    }

    private void markInUse(String key, STSClient client) {
        ArrayList<STSClient> usedClients = this.inUse.get(key);
        if (usedClients != null) {
            usedClients.add(client);
        } else {
            logger.cannotGetUsedClientsByKey(key);
        }
    }

    private synchronized void putInInternal(String key, STSClient client) {
        STSConfigData configData = this.configs.get(key);
        if (configData == null) {
            return;
        }
        ArrayList<STSClient> freeClients = this.free.get(key);
        ArrayList<STSClient> usedClients = this.inUse.get(key);
        if (usedClients != null && !usedClients.remove(client)) {
            throw logger.removingNonExistingClientFromUsedClientsByKey(key);
        }
        freeClients.add(client);
    }

    private String key(STSClientConfig stsClientConfig) {
        return this.substituteKey(stsClientConfig.getSTSClientConfigKey());
    }

    private String substituteKey(String originalKey) {
        if (originalKey != null && originalKey.indexOf("${module}") != -1) {
            return originalKey.replaceAll("\\Q${module}\\E", ModuleUtils.getCurrentModuleId());
        }
        return originalKey;
    }

    private int removeByPrefix(String prefix, Hashtable<String, ?> hashTbl) {
        int num = 0;
        Enumeration<String> keys = hashTbl.keys();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            if (!k.startsWith(prefix)) continue;
            ++num;
            hashTbl.remove(k);
        }
        return num;
    }
}

