/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;

public class KeyStoreUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(File keyStoreFile, char[] storePass) throws GeneralSecurityException, IOException {
        FileInputStream fis = new FileInputStream(keyStoreFile);
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreUtil.getKeyStore(fis, storePass);
        }
        finally {
            KeyStoreUtil.safeClose(fis);
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String fileURL, char[] storePass) throws GeneralSecurityException, IOException {
        if (fileURL == null) {
            throw logger.nullArgumentError("fileURL");
        }
        KeyStore keyStore = null;
        File file = new File(fileURL);
        FileInputStream fis = new FileInputStream(file);
        try {
            keyStore = KeyStoreUtil.getKeyStore(fis, storePass);
        }
        finally {
            KeyStoreUtil.safeClose(fis);
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(URL url, char[] storePass) throws GeneralSecurityException, IOException {
        if (url == null) {
            throw logger.nullArgumentError("url");
        }
        KeyStore keyStore = null;
        InputStream inputStream = url.openStream();
        try {
            keyStore = KeyStoreUtil.getKeyStore(inputStream, storePass);
        }
        finally {
            KeyStoreUtil.safeClose(inputStream);
        }
        return keyStore;
    }

    public static KeyStore getKeyStore(InputStream ksStream, char[] storePass) throws GeneralSecurityException, IOException {
        if (ksStream == null) {
            throw logger.nullArgumentError("InputStream for the KeyStore");
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(ksStream, storePass);
        return ks;
    }

    public static KeyPair generateKeyPair(String algo) throws GeneralSecurityException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algo);
        return kpg.genKeyPair();
    }

    public static PublicKey getPublicKey(KeyStore ks, String alias, char[] password) throws GeneralSecurityException {
        Certificate cert;
        PublicKey publicKey = null;
        Key key = ks.getKey(alias, password);
        if (key instanceof PrivateKey) {
            cert = ks.getCertificate(alias);
            publicKey = cert.getPublicKey();
        }
        if (publicKey == null && (cert = ks.getCertificate(alias)) != null) {
            publicKey = cert.getPublicKey();
        }
        return publicKey;
    }

    public static void addCertificate(File keystoreFile, char[] storePass, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStoreUtil.getKeyStore(keystoreFile, storePass);
        keystore.setCertificateEntry(alias, cert);
        FileOutputStream out = new FileOutputStream(keystoreFile);
        keystore.store(out, storePass);
        out.close();
    }

    private static void safeClose(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            logger.exceptionWhenClosingKeyStoreInputStreamWarning((Throwable)e);
        }
    }
}

