/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.Info;

public class Evaluate
extends Directive {
    @Override
    public String getName() {
        return "evaluate";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        super.init(runtimeServices, internalContextAdapter, node);
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            throw new TemplateInitException("#" + this.getName() + "() requires exactly one argument", internalContextAdapter.getCurrentTemplateName(), node.getColumn(), node.getLine());
        }
        if (n > 1) {
            throw new TemplateInitException("#" + this.getName() + "() requires exactly one argument", internalContextAdapter.getCurrentTemplateName(), node.jjtGetChild(1).getColumn(), node.jjtGetChild(1).getLine());
        }
        Node node2 = node.jjtGetChild(0);
        if (node2.getType() != 9 && node2.getType() != 20) {
            throw new TemplateInitException("#" + this.getName() + "()  argument must be a string literal or reference", internalContextAdapter.getCurrentTemplateName(), node2.getColumn(), node2.getLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object object = node.jjtGetChild(0).value(internalContextAdapter);
        String string = object != null ? object.toString() : "";
        String string2 = internalContextAdapter.getCurrentTemplateName();
        Template template = (Template)internalContextAdapter.getCurrentResource();
        if (template == null) {
            template = new Template();
            template.setName(string2);
        }
        SimpleNode simpleNode = null;
        try {
            simpleNode = this.rsvc.parse(new StringReader(string), template);
        }
        catch (TemplateInitException | ParseException exception) {
            Info info = new Info(string2, node.getLine(), node.getColumn());
            throw new ParseErrorException(exception.getMessage(), info);
        }
        if (simpleNode != null) {
            internalContextAdapter.pushCurrentTemplateName(string2);
            try {
                try {
                    simpleNode.init(internalContextAdapter, this.rsvc);
                }
                catch (TemplateInitException templateInitException) {
                    Info info = new Info(string2, node.getLine(), node.getColumn());
                    throw new ParseErrorException(templateInitException.getMessage(), info);
                }
                try {
                    this.preRender(internalContextAdapter);
                    simpleNode.render(internalContextAdapter, writer);
                }
                catch (StopCommand stopCommand) {
                    if (!stopCommand.isFor(this)) {
                        throw stopCommand;
                    }
                }
                catch (ParseErrorException parseErrorException) {
                    Info info = new Info(string2, node.getLine(), node.getColumn());
                    throw new ParseErrorException(parseErrorException.getMessage(), info);
                }
            }
            finally {
                internalContextAdapter.popCurrentTemplateName();
                this.postRender(internalContextAdapter);
            }
            return true;
        }
        return false;
    }
}

