/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.x500.X500Principal;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.LdapUtils;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.token.realm.RealmSupport;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;

public class LdapClaimsHandler
implements ClaimsHandler,
RealmSupport {
    private static final Logger LOG = LogUtils.getL7dLogger(LdapClaimsHandler.class);
    private LdapTemplate ldap;
    private Map<String, String> claimMapping;
    private String userBaseDn;
    private List<String> userBaseDNs;
    private String delimiter;
    private boolean x500FilterEnabled = true;
    private String objectClass = "person";
    private String userNameAttribute = "cn";
    private List<String> supportedRealms;
    private String realm;

    public void setSupportedRealms(List<String> supportedRealms) {
        this.supportedRealms = supportedRealms;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldap = ldapTemplate;
    }

    public LdapTemplate getLdapTemplate() {
        return this.ldap;
    }

    public void setClaimsLdapAttributeMapping(Map<String, String> ldapClaimMapping) {
        this.claimMapping = ldapClaimMapping;
    }

    public Map<String, String> getClaimsLdapAttributeMapping() {
        return this.claimMapping;
    }

    public void setUserBaseDN(String userBaseDN) {
        this.userBaseDn = userBaseDN;
    }

    public String getUserBaseDN() {
        return this.userBaseDn;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean isX500FilterEnabled() {
        return this.x500FilterEnabled;
    }

    public void setX500FilterEnabled(boolean x500FilterEnabled) {
        this.x500FilterEnabled = x500FilterEnabled;
    }

    @Override
    public List<URI> getSupportedClaimTypes() {
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (String uri : this.getClaimsLdapAttributeMapping().keySet()) {
            try {
                uriList.add(new URI(uri));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return uriList;
    }

    @Override
    public ProcessedClaimCollection retrieveClaimValues(ClaimCollection claims, ClaimsParameters parameters) {
        String user = null;
        boolean useLdapLookup = false;
        Principal principal = parameters.getPrincipal();
        if (principal instanceof KerberosPrincipal) {
            KerberosPrincipal kp = (KerberosPrincipal)principal;
            StringTokenizer st = new StringTokenizer(kp.getName(), "@");
            user = st.nextToken();
        } else {
            if (principal instanceof X500Principal) {
                X500Principal x500p = (X500Principal)principal;
                LOG.warning("Unsupported principal type X500: " + x500p.getName());
                return new ProcessedClaimCollection();
            }
            if (principal != null) {
                user = principal.getName();
                if (user == null) {
                    LOG.warning("User must not be null");
                    return new ProcessedClaimCollection();
                }
                useLdapLookup = LdapUtils.isDN(user);
            } else {
                LOG.warning("Principal is null");
                return new ProcessedClaimCollection();
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Retrieve claims for user " + user);
        }
        Map<String, Attribute> ldapAttributes = null;
        if (useLdapLookup) {
            AttributesMapper<Map<String, Attribute>> mapper = new AttributesMapper<Map<String, Attribute>>(){

                public Map<String, Attribute> mapFromAttributes(Attributes attrs) throws NamingException {
                    HashMap<String, Attribute> map = new HashMap<String, Attribute>();
                    NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
                    while (attrEnum.hasMore()) {
                        Attribute att = attrEnum.next();
                        map.put(att.getID(), att);
                    }
                    return map;
                }
            };
            ldapAttributes = (Map<String, Attribute>)this.ldap.lookup(user, (AttributesMapper)mapper);
        } else {
            ArrayList<String> searchAttributeList = new ArrayList<String>();
            for (Object claim : claims) {
                String claimType = claim.getClaimType().toString();
                if (this.getClaimsLdapAttributeMapping().keySet().contains(claimType)) {
                    searchAttributeList.add(this.getClaimsLdapAttributeMapping().get(claimType));
                    continue;
                }
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.finer("Unsupported claim: " + claimType);
            }
            String[] searchAttributes = searchAttributeList.toArray(new String[0]);
            if (this.userBaseDn != null) {
                ldapAttributes = LdapUtils.getAttributesOfEntry(this.ldap, this.userBaseDn, this.getObjectClass(), this.getUserNameAttribute(), user, searchAttributes);
            }
            if (this.userBaseDNs != null && (ldapAttributes == null || ldapAttributes.isEmpty())) {
                String userBase;
                Object claim;
                claim = this.userBaseDNs.iterator();
                while (claim.hasNext() && ((ldapAttributes = LdapUtils.getAttributesOfEntry(this.ldap, userBase = (String)claim.next(), this.getObjectClass(), this.getUserNameAttribute(), user, searchAttributes)) == null || ldapAttributes.isEmpty())) {
                }
            }
        }
        if (ldapAttributes == null || ldapAttributes.isEmpty()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("User '" + user + "' not found");
            }
            return new ProcessedClaimCollection();
        }
        ProcessedClaimCollection claimsColl = new ProcessedClaimCollection();
        for (Object claim : claims) {
            ProcessedClaim c = this.processClaim((Claim)claim, ldapAttributes, principal);
            if (c == null) continue;
            claimsColl.add(c);
        }
        return claimsColl;
    }

    protected ProcessedClaim processClaim(Claim claim, Map<String, Attribute> ldapAttributes, Principal principal) {
        URI claimType = claim.getClaimType();
        String ldapAttribute = this.getClaimsLdapAttributeMapping().get(claimType.toString());
        Attribute attr = ldapAttributes.get(ldapAttribute);
        if (attr == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Claim '" + claim.getClaimType() + "' is null");
            }
            return null;
        }
        ProcessedClaim c = new ProcessedClaim();
        c.setClaimType(claimType);
        c.setPrincipal(principal);
        try {
            NamingEnumeration<?> list = attr.getAll();
            while (list.hasMore()) {
                Object obj = list.next();
                if (obj instanceof String) {
                    String itemValue = (String)obj;
                    if (this.isX500FilterEnabled()) {
                        try {
                            X500Principal x500p = new X500Principal(itemValue);
                            itemValue = x500p.getName();
                            int index = itemValue.indexOf(61);
                            itemValue = itemValue.substring(index + 1, itemValue.indexOf(44, index));
                        }
                        catch (Throwable x500p) {
                            // empty catch block
                        }
                    }
                    if (this.delimiter != null) {
                        StringBuilder claimValue = new StringBuilder();
                        claimValue.append(itemValue);
                        if (list.hasMore()) {
                            claimValue.append(this.getDelimiter());
                            continue;
                        }
                        if (claimValue.length() <= 0) continue;
                        c.addValue(claimValue.toString());
                        continue;
                    }
                    c.addValue(itemValue);
                    continue;
                }
                if (obj instanceof byte[]) {
                    c.addValue(obj);
                    continue;
                }
                LOG.warning("LDAP attribute '" + ldapAttribute + "' has got an unsupported value type");
                break;
            }
        }
        catch (NamingException ex) {
            LOG.warning("Failed to read value of LDAP attribute '" + ldapAttribute + "'");
        }
        return c;
    }

    @Override
    public List<String> getSupportedRealms() {
        return this.supportedRealms;
    }

    @Override
    public String getHandlerRealm() {
        return this.realm;
    }

    public List<String> getUserBaseDNs() {
        return this.userBaseDNs;
    }

    public void setUserBaseDNs(List<String> userBaseDNs) {
        this.userBaseDNs = userBaseDNs;
    }
}

