/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ConsumerFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ConsumerView
extends ActiveMQAbstractView<ServerConsumer> {
    private static final String defaultSortColumn = "id";
    private final ActiveMQServer server;

    public ConsumerView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ConsumerFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return ServerConsumer.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerConsumer consumer) {
        ServerSession session = this.server.getSessionByID(consumer.getSessionID());
        if (session == null) {
            return null;
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(defaultSortColumn, this.toString(consumer.getSequentialID())).add("session", this.toString(consumer.getSessionName())).add("clientID", this.toString(consumer.getConnectionClientID())).add("user", this.toString(session.getUsername())).add("protocol", this.toString(consumer.getConnectionProtocolName())).add("queue", this.toString(consumer.getQueueName())).add("queueType", this.toString(consumer.getQueueType()).toLowerCase()).add("address", this.toString(consumer.getQueueAddress())).add("localAddress", this.toString(consumer.getConnectionLocalAddress())).add("remoteAddress", this.toString(consumer.getConnectionRemoteAddress())).add("creationTime", new Date(consumer.getCreationTime()).toString());
        return obj;
    }

    @Override
    public Object getField(ServerConsumer consumer, String fieldName) {
        ServerSession session = this.server.getSessionByID(consumer.getSessionID());
        if (session == null) {
            return null;
        }
        switch (fieldName) {
            case "id": {
                return consumer.getSequentialID();
            }
            case "session": {
                return consumer.getSessionName();
            }
            case "user": {
                return session.getUsername();
            }
            case "clientID": {
                return consumer.getConnectionClientID();
            }
            case "protocol": {
                return consumer.getConnectionProtocolName();
            }
            case "queue": {
                return consumer.getQueueName();
            }
            case "queueType": {
                return consumer.getQueueType();
            }
            case "localAddress": {
                return consumer.getConnectionLocalAddress();
            }
            case "remoteAddress": {
                return consumer.getConnectionRemoteAddress();
            }
            case "creationTime": {
                return new Date(consumer.getCreationTime());
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

