/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded.logging;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.embedded.Context;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

public class EmbeddedLogger_$logger
extends DelegatingBasicLogger
implements EmbeddedLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EmbeddedLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String invalidJBossHome = "WFLYEMB0011: Invalid JBoss home directory: %s";
    private static final String moduleLoaderError = "WFLYEMB0014: Cannot load module %s from: %s";
    private static final String nullVar = "WFLYEMB0015: %s is null";
    private static final String cannotLoadEmbeddedServerFactory = "WFLYEMB0017: Cannot load embedded server factory: %s";
    private static final String cannotGetReflectiveMethod = "WFLYEMB0018: Cannot get reflective method '%s' for: %s";
    private static final String cannotCreateStandaloneServer = "WFLYEMB0019: Cannot create standalone server using factory: %s";
    private static final String cannotSetupEmbeddedServer = "WFLYEMB0020: Cannot setup embedded process";
    private static final String cannotStartEmbeddedServer = "WFLYEMB0021: Cannot start embedded process";
    private static final String cannotInvokeStandaloneServer = "WFLYEMB0022: Cannot invoke '%s' on embedded process";
    private static final String processIsStopping = "WFLYEMB0023: The embedded server is stopping and invocations on the ModelControllerClient are not available";
    private static final String processIsReloading = "WFLYEMB0024: The embedded server is reloading and invocations on the ModelControllerClient are not yet available";
    private static final String cannotCreateHostController = "WFLYEMB0026: Cannot create host controller using factory: %s";
    private static final String processIsStopped = "WFLYEMB0027: The embedded server is stopped and invocations on the ModelControllerClient are not available";
    private static final String errorCopyingFile = "WFLYEMB0028: Error copying '%s' to '%s' (%s)";
    private static final String propertySpecifiedFileIsNotADirectory = "WFLYEMB0029: -D%s=%s is not a directory";
    private static final String propertySpecifiedFileDoesNotExist = "WFLYEMB0144: -D%s=%s does not exist";
    private static final String embeddedServerDirectoryNotFound = "WFLYEMB0143: No directory called '%s' exists under '%s'";
    private static final String moduleLoaderAlreadyConfigured = "WFLYEMB0145: The module loader has already been configured. Changing the %s property will have no effect.";
    private static final String failedToRestoreContext = "WFLYEMB0146: Failed to restore context %s";

    public EmbeddedLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidJBossHome$str() {
        return invalidJBossHome;
    }

    @Override
    public final IllegalStateException invalidJBossHome(String jbossHome) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidJBossHome$str(), jbossHome));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String moduleLoaderError$str() {
        return moduleLoaderError;
    }

    @Override
    public final RuntimeException moduleLoaderError(Throwable cause, String msg, ModuleLoader moduleLoader) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.moduleLoaderError$str(), msg, moduleLoader), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullVar$str() {
        return nullVar;
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotLoadEmbeddedServerFactory$str() {
        return cannotLoadEmbeddedServerFactory;
    }

    @Override
    public final IllegalStateException cannotLoadEmbeddedServerFactory(ClassNotFoundException cause, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotLoadEmbeddedServerFactory$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGetReflectiveMethod$str() {
        return cannotGetReflectiveMethod;
    }

    @Override
    public final IllegalStateException cannotGetReflectiveMethod(NoSuchMethodException cause, String method, String className) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotGetReflectiveMethod$str(), method, className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateStandaloneServer$str() {
        return cannotCreateStandaloneServer;
    }

    @Override
    public final IllegalStateException cannotCreateStandaloneServer(Throwable cause, Method createMethod) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCreateStandaloneServer$str(), createMethod), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSetupEmbeddedServer$str() {
        return cannotSetupEmbeddedServer;
    }

    @Override
    public final IllegalStateException cannotSetupEmbeddedServer(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSetupEmbeddedServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotStartEmbeddedServer$str() {
        return cannotStartEmbeddedServer;
    }

    @Override
    public final EmbeddedProcessStartException cannotStartEmbeddedServer(Throwable cause) {
        EmbeddedProcessStartException result = new EmbeddedProcessStartException(String.format(this.getLoggingLocale(), this.cannotStartEmbeddedServer$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInvokeStandaloneServer$str() {
        return cannotInvokeStandaloneServer;
    }

    @Override
    public final IllegalStateException cannotInvokeStandaloneServer(Throwable cause, String methodName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotInvokeStandaloneServer$str(), methodName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String processIsStopping$str() {
        return processIsStopping;
    }

    @Override
    public final IllegalStateException processIsStopping() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsStopping$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String processIsReloading$str() {
        return processIsReloading;
    }

    @Override
    public final IllegalStateException processIsReloading() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsReloading$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotCreateHostController$str() {
        return cannotCreateHostController;
    }

    @Override
    public final IllegalStateException cannotCreateHostController(Throwable cause, Method createMethod) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCreateHostController$str(), createMethod), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String processIsStopped$str() {
        return processIsStopped;
    }

    @Override
    public final IllegalStateException processIsStopped() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsStopped$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCopyingFile$str() {
        return errorCopyingFile;
    }

    @Override
    public final RuntimeException errorCopyingFile(String absolutePath, String absolutePath2, IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.errorCopyingFile$str(), absolutePath, absolutePath2, e));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertySpecifiedFileIsNotADirectory$str() {
        return propertySpecifiedFileIsNotADirectory;
    }

    @Override
    public final IllegalArgumentException propertySpecifiedFileIsNotADirectory(String property, String absolutePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.propertySpecifiedFileIsNotADirectory$str(), property, absolutePath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertySpecifiedFileDoesNotExist$str() {
        return propertySpecifiedFileDoesNotExist;
    }

    @Override
    public final IllegalArgumentException propertySpecifiedFileDoesNotExist(String property, String absolutePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.propertySpecifiedFileDoesNotExist$str(), property, absolutePath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String embeddedServerDirectoryNotFound$str() {
        return embeddedServerDirectoryNotFound;
    }

    @Override
    public final IllegalArgumentException embeddedServerDirectoryNotFound(String string, String absolutePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.embeddedServerDirectoryNotFound$str(), string, absolutePath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void moduleLoaderAlreadyConfigured(String propertyName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.moduleLoaderAlreadyConfigured$str(), (Object)propertyName);
    }

    protected String moduleLoaderAlreadyConfigured$str() {
        return moduleLoaderAlreadyConfigured;
    }

    @Override
    public final void failedToRestoreContext(Throwable cause, Context context) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToRestoreContext$str(), (Object)context);
    }

    protected String failedToRestoreContext$str() {
        return failedToRestoreContext;
    }
}

