/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.KeyAwareLockPromise;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockingInterceptor
extends NonTransactionalLockingInterceptor {
    private static final Log log = LogFactory.getLog(LockingInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final InvocationFinallyFunction unlockAllReturnCheckCompletableFutureHandler = (rCtx, rCommand, rv, throwable) -> {
        this.lockManager.unlockAll(rCtx);
        if (throwable != null) {
            throw throwable;
        }
        if (rv instanceof CompletableFuture) {
            return LockingInterceptor.asyncValue((CompletionStage)((CompletableFuture)rv));
        }
        return rv;
    };
    protected final InvocationFinallyFunction invokeNextAndUnlock = (rCtx, rCommand, rv, throwable) -> {
        if (throwable != null) {
            this.lockManager.unlockAll(rCtx);
            DataWriteCommand dataWriteCommand = (DataWriteCommand)rCommand;
            if (throwable instanceof TimeoutException && dataWriteCommand.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT)) {
                dataWriteCommand.fail();
                return null;
            }
            throw throwable;
        }
        return this.invokeNextAndHandle(rCtx, rCommand, this.unlockAllReturnCheckCompletableFutureHandler);
    };

    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            if (trace) {
                Ownership ownership = this.cdl.getCacheTopology().getDistribution(command.getKey()).writeOwnership();
                log.tracef("Am I owner for key=%s ? %s", command.getKey(), (Object)ownership);
            }
            if (ctx.getLockOwner() == null) {
                ctx.setLockOwner((Object)command.getCommandInvocationId());
            }
            KeyAwareLockPromise lockPromise = this.lockAndRecord(ctx, command.getKey(), this.getLockTimeoutMillis((FlagAffectedCommand)command));
            return lockPromise.toInvocationStage().andHandle(ctx, (VisitableCommand)command, this.invokeNextAndUnlock);
        }
        catch (Throwable t) {
            this.lockManager.unlockAll(ctx);
            throw t;
        }
    }
}

