/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DoubleAttribute;
import org.jboss.security.xacml.sunxacml.attr.IntegerAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.FunctionBase;

public class AddFunction
extends FunctionBase {
    public static final String NAME_INTEGER_ADD = "urn:oasis:names:tc:xacml:1.0:function:integer-add";
    public static final String NAME_DOUBLE_ADD = "urn:oasis:names:tc:xacml:1.0:function:double-add";
    private static final int ID_INTEGER_ADD = 0;
    private static final int ID_DOUBLE_ADD = 1;

    public AddFunction(String functionName) {
        super(functionName, AddFunction.getId(functionName), AddFunction.getArgumentType(functionName), false, -1, 2, AddFunction.getArgumentType(functionName), false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_INTEGER_ADD)) {
            return 0;
        }
        if (functionName.equals(NAME_DOUBLE_ADD)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown add function " + functionName);
    }

    private static String getArgumentType(String functionName) {
        if (functionName.equals(NAME_INTEGER_ADD)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_INTEGER_ADD);
        set.add(NAME_DOUBLE_ADD);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                long sum = 0L;
                for (int index = 0; index < argValues.length; ++index) {
                    long arg = ((IntegerAttribute)argValues[index]).getValue();
                    sum += arg;
                }
                result = new EvaluationResult(new IntegerAttribute(sum));
                break;
            }
            case 1: {
                double sum = 0.0;
                for (int index = 0; index < argValues.length; ++index) {
                    double arg = ((DoubleAttribute)argValues[index]).getValue();
                    sum += arg;
                }
                result = new EvaluationResult(new DoubleAttribute(sum));
                break;
            }
        }
        return result;
    }
}

