/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.validation;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class ConstraintTypeUtil11
implements ConstraintTypeUtil {
    @Override
    public ConstraintType.Type getConstraintType(Object o) {
        if (!(o instanceof ConstraintViolation)) {
            throw new RuntimeException(Messages.MESSAGES.unknownObjectPassedAsConstraintViolation(o));
        }
        ConstraintViolation v = (ConstraintViolation)ConstraintViolation.class.cast(o);
        Iterator nodes = v.getPropertyPath().iterator();
        Path.Node firstNode = (Path.Node)nodes.next();
        if (firstNode.getKind() == ElementKind.METHOD) {
            Path.Node secondNode = (Path.Node)nodes.next();
            if (secondNode.getKind() == ElementKind.PARAMETER || secondNode.getKind() == ElementKind.CROSS_PARAMETER) {
                return ConstraintType.Type.PARAMETER;
            }
            if (secondNode.getKind() == ElementKind.RETURN_VALUE) {
                return ConstraintType.Type.RETURN_VALUE;
            }
            throw new RuntimeException(Messages.MESSAGES.unexpectedPathNodeViolation(secondNode.getKind()));
        }
        if (firstNode.getKind() == ElementKind.BEAN) {
            return ConstraintType.Type.CLASS;
        }
        if (firstNode.getKind() == ElementKind.PROPERTY) {
            String fieldName = firstNode.getName();
            try {
                String getterName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                ConstraintTypeUtil11.getMethod(v.getRootBeanClass(), getterName);
                return ConstraintType.Type.PROPERTY;
            }
            catch (NoSuchMethodException e) {
                try {
                    String getterName = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    Method m = ConstraintTypeUtil11.getMethod(v.getLeafBean().getClass(), getterName);
                    if (m.getReturnType().equals(Boolean.TYPE)) {
                        return ConstraintType.Type.PROPERTY;
                    }
                    return ConstraintType.Type.FIELD;
                }
                catch (NoSuchMethodException e1) {
                    return ConstraintType.Type.FIELD;
                }
            }
        }
        throw new RuntimeException(Messages.MESSAGES.unexpectedPathNode(firstNode.getKind()));
    }

    private static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method method = null;
        method = ConstraintTypeUtil11.checkMethodAccess(clazz, methodName);
        while (method == null && (clazz = clazz.getSuperclass()) != null) {
            method = ConstraintTypeUtil11.checkMethodAccess(clazz, methodName);
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    private static Method checkMethodAccess(final Class<?> clazz, final String methodName) {
        Method method = null;
        try {
            method = System.getSecurityManager() == null ? clazz.getDeclaredMethod(methodName, new Class[0]) : AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz.getDeclaredMethod(methodName, new Class[0]);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }
}

