/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.modules.AbstractResourceLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.URLConnectionResource;

final class ServiceResourceLoader
extends AbstractResourceLoader {
    private final Map<String, URLConnectionResource> servicesMap;
    private static final String PREFIX = "data:text/plain;charset=UTF-8,";

    ServiceResourceLoader(Map<String, URLConnectionResource> map) {
        this.servicesMap = map;
    }

    @Override
    public Resource getResource(String name) {
        if (name.startsWith("META-INF/services/")) {
            return this.servicesMap.get(name.substring("META-INF/services/".length()));
        }
        return null;
    }

    @Override
    public Collection<String> getPaths() {
        return Collections.singleton("META-INF/services");
    }

    static URLConnectionResource createResource(List<String> implNames) {
        int len = PREFIX.length();
        Iterator<String> iterator = implNames.iterator();
        if (iterator.hasNext()) {
            len = iterator.next().length();
            while (iterator.hasNext()) {
                len += 1 + iterator.next().length();
            }
        }
        if (len == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(PREFIX);
        iterator = implNames.iterator();
        if (iterator.hasNext()) {
            sb.append(iterator.next());
            while (iterator.hasNext()) {
                sb.append('\n');
                sb.append(iterator.next());
            }
        }
        try {
            return new URLConnectionResource(new URL(sb.toString()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create URL", e);
        }
    }
}

