/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.LegacyEndpoint;
import org.jboss.remoting3.security.RemotingPermission;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@Deprecated
public final class Remoting {
    private static final RemotingPermission CREATE_ENDPOINT_PERM = new RemotingPermission("createEndpoint");

    public static Endpoint createEndpoint(String endpointName, XnioWorker xnioWorker, OptionMap optionMap) throws IOException {
        if (endpointName == null) {
            throw new IllegalArgumentException("endpointName is null");
        }
        if (optionMap == null) {
            throw new IllegalArgumentException("optionMap is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)CREATE_ENDPOINT_PERM));
        }
        EndpointBuilder builder = Endpoint.builder();
        builder.setXnioWorker(xnioWorker);
        builder.setEndpointName(endpointName);
        return new LegacyEndpoint(builder.build());
    }

    public static Endpoint createEndpoint(String endpointName, Xnio xnio, OptionMap optionMap) throws IOException {
        if (endpointName == null) {
            throw new IllegalArgumentException("endpointName is null");
        }
        if (optionMap == null) {
            throw new IllegalArgumentException("optionMap is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)CREATE_ENDPOINT_PERM));
        }
        OptionMap modifiedOptionMap = OptionMap.builder().addAll(optionMap).set(Options.WORKER_NAME, (Object)(endpointName == null ? "Remoting (anonymous)" : "Remoting \"" + endpointName + "\"")).getMap();
        final AtomicReference<Endpoint> endpointRef = new AtomicReference<Endpoint>();
        XnioWorker xnioWorker = xnio.createWorker(null, modifiedOptionMap, new Runnable(){

            @Override
            public void run() {
                Endpoint endpoint = endpointRef.getAndSet(null);
                if (endpoint != null) {
                    ((EndpointImpl)endpoint).closeComplete();
                }
            }
        });
        EndpointBuilder builder = Endpoint.builder();
        builder.setXnioWorker(xnioWorker);
        builder.setEndpointName(endpointName);
        Endpoint endpoint = builder.build();
        endpointRef.set(endpoint);
        return new LegacyEndpoint(endpoint);
    }

    public static Endpoint createEndpoint(String endpointName, OptionMap optionMap) throws IOException {
        return Remoting.createEndpoint(endpointName, Xnio.getInstance(), optionMap);
    }

    public static Endpoint createEndpoint(OptionMap optionMap) throws IOException {
        return Remoting.createEndpoint(null, optionMap);
    }

    public static Endpoint createEndpoint() throws IOException {
        return Remoting.createEndpoint(null, OptionMap.EMPTY);
    }

    private Remoting() {
    }
}

