/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.servlet.core.InMemorySessionManagerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.SimpleCapabilityServiceConfigurator;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.web.session.SessionManagerFactoryServiceConfiguratorProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactoryServiceConfigurator;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;

public class DistributableSessionManagerFactoryServiceConfiguratorProvider
implements org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryServiceConfiguratorProvider {
    private static final SessionManagerFactoryServiceConfiguratorProvider PROVIDER = DistributableSessionManagerFactoryServiceConfiguratorProvider.loadProvider();

    private static SessionManagerFactoryServiceConfiguratorProvider loadProvider() {
        Iterator<SessionManagerFactoryServiceConfiguratorProvider> iterator = ServiceLoader.load(SessionManagerFactoryServiceConfiguratorProvider.class, SessionManagerFactoryServiceConfiguratorProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            SessionManagerFactoryServiceConfiguratorProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public CapabilityServiceConfigurator getServiceConfigurator(ServiceName name, DistributableSessionManagerConfiguration configuration) {
        if (PROVIDER == null) {
            UndertowLogger.ROOT_LOGGER.clusteringNotSupported();
            return new SimpleCapabilityServiceConfigurator(name, (Object)new InMemorySessionManagerFactory(configuration.getMaxActiveSessions()));
        }
        return new DistributableSessionManagerFactoryServiceConfigurator(name, configuration, PROVIDER);
    }
}

