/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Predicate;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;

public class WorkQueuePerIndexSplitter {
    private final IndexManagerHolder indexManagerHolder;
    private final Predicate<IndexManager> indexManagerFilter;
    private final HashMap<String, WorkPlan> queues = new HashMap();

    public WorkQueuePerIndexSplitter(IndexManagerHolder indexManagerHolder, Predicate<IndexManager> indexManagerFilter) {
        this.indexManagerHolder = indexManagerHolder;
        this.indexManagerFilter = indexManagerFilter;
    }

    public void addToQueue(IndexManager indexManager, LuceneWork work) {
        if (!this.indexManagerFilter.test(indexManager)) {
            return;
        }
        String indexName = indexManager.getIndexName();
        WorkPlan plan = this.queues.get(indexName);
        if (plan == null) {
            BackendQueueProcessor backendQueueProcessor = this.indexManagerHolder.getBackendQueueProcessor(indexName);
            if (backendQueueProcessor == null) {
                throw new AssertionFailure("Backend for index '" + indexName + "' not defined");
            }
            plan = new WorkPlan(backendQueueProcessor);
            this.queues.put(indexName, plan);
        }
        plan.queue.add(work);
    }

    public void performStreamOperation(IndexManager indexManager, LuceneWork work) {
        if (!this.indexManagerFilter.test(indexManager)) {
            return;
        }
        indexManager.performStreamOperation(work, null, false);
    }

    public void commitOperations(IndexingMonitor monitor) {
        for (WorkPlan plan : this.queues.values()) {
            plan.backendQueueProcessor.applyWork(plan.queue, monitor);
        }
    }

    private static class WorkPlan {
        private final BackendQueueProcessor backendQueueProcessor;
        private final LinkedList<LuceneWork> queue = new LinkedList();

        WorkPlan(BackendQueueProcessor backendQueueProcessor) {
            this.backendQueueProcessor = backendQueueProcessor;
        }
    }
}

