/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LazyExecutorHolder {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final int maxQueueLength;
    private final String threadNamePrefix;
    private final String indexName;
    private final ReentrantReadWriteLock.ReadLock executorStateReadLock;
    private final ReentrantReadWriteLock.WriteLock executorStateWriteLock;
    private ExecutorService asyncIndexingExecutor;

    public LazyExecutorHolder(int maxQueueLength, String indexName, String threadNamePrefix) {
        this.maxQueueLength = maxQueueLength;
        this.indexName = indexName;
        this.threadNamePrefix = threadNamePrefix;
        ReentrantReadWriteLock executorStateReadWriteLock = new ReentrantReadWriteLock();
        this.executorStateReadLock = executorStateReadWriteLock.readLock();
        this.executorStateWriteLock = executorStateReadWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(LuceneBackendQueueTask task) {
        ExecutorService executor;
        this.executorStateReadLock.lock();
        try {
            executor = this.asyncIndexingExecutor;
            if (executor != null) {
                executor.submit(task);
                return;
            }
        }
        finally {
            this.executorStateReadLock.unlock();
        }
        this.executorStateWriteLock.lock();
        try {
            executor = this.asyncIndexingExecutor;
            if (executor == null) {
                this.asyncIndexingExecutor = executor = Executors.newFixedThreadPool(1, this.threadNamePrefix, this.maxQueueLength);
            }
            executor.submit(task);
        }
        finally {
            this.executorStateWriteLock.unlock();
        }
    }

    public void flushCloseExecutor() {
        this.executorStateWriteLock.lock();
        try {
            if (this.asyncIndexingExecutor == null) {
                return;
            }
            this.asyncIndexingExecutor.shutdown();
            try {
                this.asyncIndexingExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.interruptedWhileWaitingForIndexActivity(this.indexName, e);
            }
            if (!this.asyncIndexingExecutor.isTerminated()) {
                log.unableToShutdownAsynchronousIndexingByTimeout(this.indexName);
            }
            this.asyncIndexingExecutor = null;
        }
        finally {
            this.executorStateWriteLock.unlock();
        }
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }
}

