/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.LockFactoryProvider;
import org.hibernate.search.store.spi.LockFactoryCreator;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultLockFactoryCreator
implements LockFactoryCreator,
Startable {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private ServiceManager serviceManager;

    @Override
    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
    }

    @Override
    public LockFactory createLockFactory(Path indexDir, Properties dirConfiguration) {
        String defaultStrategy = indexDir == null ? "single" : "native";
        String lockFactoryName = dirConfiguration.getProperty("locking_strategy", defaultStrategy);
        if ("simple".equals(lockFactoryName)) {
            if (indexDir == null) {
                throw LOG.indexBasePathRequiredForLockingStrategy("simple");
            }
            return SimpleFSLockFactory.INSTANCE;
        }
        if ("native".equals(lockFactoryName)) {
            if (indexDir == null) {
                throw LOG.indexBasePathRequiredForLockingStrategy("native");
            }
            return NativeFSLockFactory.INSTANCE;
        }
        if ("single".equals(lockFactoryName)) {
            return new SingleInstanceLockFactory();
        }
        if ("none".equals(lockFactoryName)) {
            return NoLockFactory.INSTANCE;
        }
        LockFactoryProvider lockFactoryFactory = ClassLoaderHelper.instanceFromName(LockFactoryProvider.class, lockFactoryName, "locking_strategy", this.serviceManager);
        File legacy = indexDir == null ? null : indexDir.toFile();
        return lockFactoryFactory.createLockFactory(legacy, dirConfiguration);
    }
}

