/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;

public class BlockJoinComparatorSource
extends FieldComparatorSource {
    final Query parentsFilter;
    final Sort parentSort;
    final Sort childSort;

    public BlockJoinComparatorSource(Query parentsFilter, Sort parentSort) {
        this(parentsFilter, parentSort, new Sort(SortField.FIELD_DOC));
    }

    public BlockJoinComparatorSource(Query parentsFilter, Sort parentSort, Sort childSort) {
        this.parentsFilter = parentsFilter;
        this.parentSort = parentSort;
        this.childSort = childSort;
    }

    public FieldComparator<Integer> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        final int[] parentSlots = new int[numHits];
        final int[] childSlots = new int[numHits];
        SortField[] parentFields = this.parentSort.getSort();
        final int[] parentReverseMul = new int[parentFields.length];
        final FieldComparator[] parentComparators = new FieldComparator[parentFields.length];
        for (int i = 0; i < parentFields.length; ++i) {
            parentReverseMul[i] = parentFields[i].getReverse() ? -1 : 1;
            parentComparators[i] = parentFields[i].getComparator(1, i);
        }
        SortField[] childFields = this.childSort.getSort();
        final int[] childReverseMul = new int[childFields.length];
        final FieldComparator[] childComparators = new FieldComparator[childFields.length];
        for (int i = 0; i < childFields.length; ++i) {
            childReverseMul[i] = childFields[i].getReverse() ? -1 : 1;
            childComparators[i] = childFields[i].getComparator(1, i);
        }
        return new FieldComparator<Integer>(){
            int bottomParent;
            int bottomChild;
            BitSet parentBits;
            LeafFieldComparator[] parentLeafComparators;
            LeafFieldComparator[] childLeafComparators;

            public int compare(int slot1, int slot2) {
                try {
                    return this.compare(childSlots[slot1], parentSlots[slot1], childSlots[slot2], parentSlots[slot2]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void setTopValue(Integer value) {
                throw new UnsupportedOperationException("this comparator cannot be used with deep paging");
            }

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                int i;
                if (this.parentBits != null) {
                    throw new IllegalStateException("This comparator can only be used on a single segment");
                }
                IndexSearcher searcher = new IndexSearcher(ReaderUtil.getTopLevelContext((IndexReaderContext)context));
                searcher.setQueryCache(null);
                Weight weight = searcher.createNormalizedWeight(BlockJoinComparatorSource.this.parentsFilter, false);
                Scorer parents = weight.scorer(context);
                if (parents == null) {
                    throw new IllegalStateException("LeafReader " + context.reader() + " contains no parents!");
                }
                this.parentBits = BitSet.of((DocIdSetIterator)parents.iterator(), (int)context.reader().maxDoc());
                this.parentLeafComparators = new LeafFieldComparator[parentComparators.length];
                for (i = 0; i < parentComparators.length; ++i) {
                    this.parentLeafComparators[i] = parentComparators[i].getLeafComparator(context);
                }
                this.childLeafComparators = new LeafFieldComparator[childComparators.length];
                for (i = 0; i < childComparators.length; ++i) {
                    this.childLeafComparators[i] = childComparators[i].getLeafComparator(context);
                }
                return new LeafFieldComparator(){

                    public int compareBottom(int doc) throws IOException {
                        return this.compare(bottomChild, bottomParent, doc, this.parent(doc));
                    }

                    public int compareTop(int doc) throws IOException {
                        throw new UnsupportedOperationException("this comparator cannot be used with deep paging");
                    }

                    public void copy(int slot, int doc) throws IOException {
                        childSlots[slot] = doc;
                        parentSlots[slot] = this.parent(doc);
                    }

                    public void setBottom(int slot) {
                        bottomParent = parentSlots[slot];
                        bottomChild = childSlots[slot];
                    }

                    public void setScorer(Scorer scorer) {
                        for (LeafFieldComparator comp : parentLeafComparators) {
                            comp.setScorer(scorer);
                        }
                        for (LeafFieldComparator comp : childLeafComparators) {
                            comp.setScorer(scorer);
                        }
                    }
                };
            }

            public Integer value(int slot) {
                throw new UnsupportedOperationException("filling sort field values is not yet supported");
            }

            int parent(int doc) {
                return this.parentBits.nextSetBit(doc);
            }

            int compare(int docID1, int parent1, int docID2, int parent2) throws IOException {
                if (parent1 == parent2) {
                    if (docID1 == parent1 || docID2 == parent2) {
                        return docID1 - docID2;
                    }
                    return this.compare(docID1, docID2, this.childLeafComparators, childReverseMul);
                }
                int cmp = this.compare(parent1, parent2, this.parentLeafComparators, parentReverseMul);
                if (cmp == 0) {
                    return parent1 - parent2;
                }
                return cmp;
            }

            int compare(int docID1, int docID2, LeafFieldComparator[] comparators, int[] reverseMul) throws IOException {
                for (int i = 0; i < comparators.length; ++i) {
                    comparators[i].copy(0, docID1);
                    comparators[i].setBottom(0);
                    int comp = reverseMul[i] * comparators[i].compareBottom(docID2);
                    if (comp == 0) continue;
                    return comp;
                }
                return 0;
            }
        };
    }

    public String toString() {
        return "blockJoin(parentSort=" + this.parentSort + ",childSort=" + this.childSort + ")";
    }
}

