/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.RawPassword;
import org.wildfly.security.password.interfaces.SunUnixMD5CryptPassword;

class RawSunUnixMD5CryptPassword
extends RawPassword
implements SunUnixMD5CryptPassword {
    private static final long serialVersionUID = 4226779284949037679L;
    private final byte[] salt;
    private final byte[] hash;
    private final int iterationCount;

    RawSunUnixMD5CryptPassword(String algorithm, byte[] salt, byte[] hash, int iterationCount) {
        super(algorithm);
        this.salt = salt;
        this.hash = hash;
        this.iterationCount = iterationCount;
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public RawSunUnixMD5CryptPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.hash), Arrays.hashCode(this.salt)), this.iterationCount), this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawSunUnixMD5CryptPassword)) {
            return false;
        }
        RawSunUnixMD5CryptPassword other = (RawSunUnixMD5CryptPassword)obj;
        return this.iterationCount == other.iterationCount && this.getAlgorithm().equals(other.getAlgorithm()) && Arrays.equals(this.hash, other.hash) && Arrays.equals(this.salt, other.salt);
    }
}

