/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.address;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.address.AddressAbstract;

@Command(name="show", description="Get the selected address")
public class ShowAddress
extends AddressAbstract {
    @Option(name={"--bindings"}, description="Shows the bindings for this address")
    boolean bindings;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.showAddress(context);
        return null;
    }

    private void showAddress(final ActionContext context) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                if (ShowAddress.this.getName(false) == null) {
                    ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listAddresses", (Object[])new Object[]{"\n"});
                } else if (ShowAddress.this.bindings) {
                    ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listBindingsForAddress", (Object[])new Object[]{ShowAddress.this.getName(false)});
                } else {
                    ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"getAddressInfo", (Object[])new Object[]{ShowAddress.this.getName(false)});
                }
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                String result = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.out.println(result);
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.err.println("Failed to show address " + ShowAddress.this.getName(false) + ". Reason: " + errMsg);
            }
        });
    }

    public boolean isBindings() {
        return this.bindings;
    }

    public void setBindings(boolean bindings) {
        this.bindings = bindings;
    }
}

