/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ejb.Asynchronous;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.interceptors.AsyncFutureInterceptorFactory;
import org.jboss.as.ejb3.component.interceptors.LogDiagnosticContextRecoveryInterceptor;
import org.jboss.as.ejb3.component.interceptors.LogDiagnosticContextStorageInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.SecurityDomainInterceptorFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.AsyncMethodMetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class AsynchronousMergingProcessor
extends AbstractMergingProcessor<SessionBeanComponentDescription> {
    final ServiceName asynchronousThreadPoolService;

    public AsynchronousMergingProcessor(ServiceName asynchronousThreadPoolService) {
        super(SessionBeanComponentDescription.class);
        this.asynchronousThreadPoolService = asynchronousThreadPoolService;
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, SessionBeanComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation data = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, Asynchronous.class);
        for (Map.Entry entry : data.getClassAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            description.addAsynchronousClass((String)entry.getKey());
        }
        for (Map.Entry entry : data.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            description.addAsynchronousMethod(MethodIdentifier.getIdentifierForMethod((Method)((Method)entry.getKey())));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, final DeploymentReflectionIndex deploymentReflectionIndex, final Class<?> componentClass, SessionBeanComponentDescription description) throws DeploymentUnitProcessingException {
        SessionBean31MetaData sessionBeanData;
        AsyncMethodsMetaData async;
        SessionBeanMetaData data = description.getDescriptorData();
        final boolean isSecurityDomainKnown = description.isSecurityDomainKnown();
        if (data != null && data instanceof SessionBean31MetaData && (async = (sessionBeanData = (SessionBean31MetaData)data).getAsyncMethods()) != null) {
            for (AsyncMethodMetaData method : async) {
                Collection<Method> methods = MethodResolutionUtils.resolveMethods(method.getMethodName(), method.getMethodParams(), componentClass, deploymentReflectionIndex);
                for (Method m : methods) {
                    description.addAsynchronousMethod(MethodIdentifier.getIdentifierForMethod((Method)m));
                }
            }
        }
        if (!description.getAsynchronousClasses().isEmpty() || !description.getAsynchronousMethods().isEmpty()) {
            description.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.getCreateDependencies().add(new DependencyConfigurator<SessionBeanComponentCreateService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, SessionBeanComponentCreateService service) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(AsynchronousMergingProcessor.this.asynchronousThreadPoolService, ExecutorService.class, service.getAsyncExecutorService());
                        }
                    });
                }
            });
            for (ViewDescription view : description.getViews()) {
                EJBViewDescription ejbView = (EJBViewDescription)view;
                ejbView.getConfigurators().add(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        SessionBeanComponentDescription componentDescription = (SessionBeanComponentDescription)componentConfiguration.getComponentDescription();
                        for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                            Method componentMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (Class)componentClass, (Method)method);
                            if (componentMethod == null) continue;
                            if (componentDescription.getAsynchronousClasses().contains(componentMethod.getDeclaringClass().getName())) {
                                AsynchronousMergingProcessor.addAsyncInterceptor(configuration, method, isSecurityDomainKnown);
                                configuration.addAsyncMethod(method);
                                continue;
                            }
                            MethodIdentifier id = MethodIdentifier.getIdentifierForMethod((Method)method);
                            if (!componentDescription.getAsynchronousMethods().contains(id)) continue;
                            AsynchronousMergingProcessor.addAsyncInterceptor(configuration, method, isSecurityDomainKnown);
                            configuration.addAsyncMethod(method);
                        }
                    }
                });
            }
        }
    }

    private static void addAsyncInterceptor(ViewConfiguration configuration, Method method, boolean isSecurityDomainKnown) throws DeploymentUnitProcessingException {
        if (method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(Future.class)) {
            configuration.addClientInterceptor(method, (InterceptorFactory)LogDiagnosticContextStorageInterceptor.getFactory(), 384);
            if (isSecurityDomainKnown) {
                configuration.addClientInterceptor(method, SecurityDomainInterceptorFactory.INSTANCE, 400);
            }
        } else {
            throw EjbLogger.ROOT_LOGGER.wrongReturnTypeForAsyncMethod(method);
        }
        configuration.addClientInterceptor(method, AsyncFutureInterceptorFactory.INSTANCE, 512);
        configuration.addClientInterceptor(method, (InterceptorFactory)LogDiagnosticContextRecoveryInterceptor.getFactory(), 640);
    }
}

