/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.GracefulShutdownService;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class ServerDomainProcessShutdownHandler
implements OperationStepHandler {
    protected static final SimpleAttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.INT).setDefaultValue(new ModelNode(0))).setRequired(false)).setMeasurementUnit(MeasurementUnit.SECONDS)).build();
    public static final SimpleOperationDefinition DOMAIN_DEFINITION = new SimpleOperationDefinitionBuilder("shutdown", ServerDescriptions.getResourceDescriptionResolver(new String[0])).setParameters(new AttributeDefinition[]{TIMEOUT}).setPrivateEntry().withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HOST_CONTROLLER_ONLY, OperationEntry.Flag.RUNTIME_ONLY}).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        final int timeout = TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.acquireControllerLock();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        ServiceController suspendControllerServiceController;
                        ServiceRegistry registry;
                        ServiceController gracefulController;
                        if (resultAction == OperationContext.ResultAction.KEEP && (gracefulController = (registry = context.getServiceRegistry(false)).getService(GracefulShutdownService.SERVICE_NAME)) != null && (suspendControllerServiceController = registry.getService(Services.JBOSS_SUSPEND_CONTROLLER)) != null) {
                            ((GracefulShutdownService)gracefulController.getValue()).startGracefulShutdown();
                            ((SuspendController)suspendControllerServiceController.getValue()).suspend(timeout > 0 ? (long)(timeout * 1000) : (long)timeout);
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

