/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics.deployment;

import io.smallrye.metrics.MetricRegistries;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.metrics.MetricsRegistrationService;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;

public class DeploymentMetricService
implements Service {
    private final Resource rootResource;
    private final ManagementResourceRegistration managementResourceRegistration;
    private PathAddress deploymentAddress;
    private final Supplier<MetricsRegistrationService> registrationService;
    private Set<String> registeredMetrics = new HashSet<String>();

    public static void install(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Resource rootResource, ManagementResourceRegistration managementResourceRegistration) {
        PathAddress deploymentAddress = DeploymentMetricService.createDeploymentAddressPrefix(deploymentUnit);
        ServiceBuilder sb = serviceTarget.addService(deploymentUnit.getServiceName().append(new String[]{"metrics"}));
        Supplier registrationService = sb.requires(MicroProfileMetricsSubsystemDefinition.WILDFLY_REGISTRATION_SERVICE);
        sb.requires(DeploymentCompleteServiceProcessor.serviceName((ServiceName)deploymentUnit.getServiceName()));
        sb.setInstance((Service)new DeploymentMetricService(rootResource, managementResourceRegistration, deploymentAddress, registrationService)).install();
    }

    private DeploymentMetricService(Resource rootResource, ManagementResourceRegistration managementResourceRegistration, PathAddress deploymentAddress, Supplier<MetricsRegistrationService> registrationService) {
        this.rootResource = rootResource;
        this.managementResourceRegistration = managementResourceRegistration;
        this.deploymentAddress = deploymentAddress;
        this.registrationService = registrationService;
    }

    public void start(StartContext startContext) {
        MetricRegistry applicationRegistry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);
        this.registeredMetrics = this.registrationService.get().registerMetrics(this.rootResource, (ImmutableManagementResourceRegistration)this.managementResourceRegistration, applicationRegistry, address -> this.deploymentAddress.append(address));
    }

    public void stop(StopContext stopContext) {
        if (this.registeredMetrics != null) {
            MetricRegistry applicationRegistry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);
            for (String registeredMetric : this.registeredMetrics) {
                applicationRegistry.remove(registeredMetric);
            }
            this.registeredMetrics = null;
        }
    }

    private static PathAddress createDeploymentAddressPrefix(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            return PathAddress.pathAddress((String)"deployment", (String)deploymentUnit.getName());
        }
        return DeploymentMetricService.createDeploymentAddressPrefix(deploymentUnit.getParent()).append("subdeployment", deploymentUnit.getName());
    }
}

