/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class CacheConfigurationServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Consumer<ConfigurationBuilder>,
Dependency {
    private final ConfigurationServiceConfigurator configurator;
    private final SupplierDependency<MemoryConfiguration> memory;
    private final SupplierDependency<ExpirationConfiguration> expiration;
    private final SupplierDependency<LockingConfiguration> locking;
    private final SupplierDependency<PersistenceConfiguration> persistence;
    private final SupplierDependency<TransactionConfiguration> transaction;
    private final SupplierDependency<Module> module;
    private volatile JMXStatisticsConfiguration statistics;

    CacheConfigurationServiceConfigurator(PathAddress address) {
        super((Capability)CacheResourceDefinition.Capability.CONFIGURATION, address);
        this.memory = new ServiceSupplierDependency(CacheComponent.MEMORY.getServiceName(address));
        this.expiration = new ServiceSupplierDependency(CacheComponent.EXPIRATION.getServiceName(address));
        this.locking = new ServiceSupplierDependency(CacheComponent.LOCKING.getServiceName(address));
        this.persistence = new ServiceSupplierDependency(CacheComponent.PERSISTENCE.getServiceName(address));
        this.transaction = new ServiceSupplierDependency(CacheComponent.TRANSACTION.getServiceName(address));
        this.module = new ServiceSupplierDependency(CacheComponent.MODULE.getServiceName(address));
        String containerName = address.getParent().getLastElement().getValue();
        String cacheName = address.getLastElement().getValue();
        this.configurator = new ConfigurationServiceConfigurator(this.getServiceName(), containerName, cacheName, this.andThen(builder -> {
            GroupsConfigurationBuilder groupsBuilder = builder.clustering().hash().groups().enabled();
            for (Grouper grouper : ((Module)this.module.get()).loadService(Grouper.class)) {
                groupsBuilder.addGrouper(grouper);
            }
        })).require((Dependency)this);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        return this.configurator.build(target);
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return new CompositeDependency(new Dependency[]{this.memory, this.expiration, this.locking, this.persistence, this.transaction, this.module}).register(builder);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        boolean enabled = CacheResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.statistics = new ConfigurationBuilder().jmxStatistics().enabled(enabled).available(enabled).create();
        this.configurator.configure(context);
        return this;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        builder.memory().read((MemoryConfiguration)this.memory.get());
        builder.expiration().read((ExpirationConfiguration)this.expiration.get());
        builder.locking().read((LockingConfiguration)this.locking.get());
        builder.persistence().read((PersistenceConfiguration)this.persistence.get());
        builder.transaction().read((TransactionConfiguration)this.transaction.get());
        builder.jmxStatistics().read(this.statistics);
        builder.eviction().strategy(EvictionStrategy.MANUAL);
    }

    MemoryConfiguration memory() {
        return (MemoryConfiguration)this.memory.get();
    }

    PersistenceConfiguration persistence() {
        return (PersistenceConfiguration)this.persistence.get();
    }

    TransactionConfiguration transaction() {
        return (TransactionConfiguration)this.transaction.get();
    }
}

