/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.jms.Topic;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSTopicService
implements Service<Topic> {
    static final String JMS_TOPIC_PREFIX = "jms.topic.";
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final String name;
    private Topic topic;

    public JMSTopicService(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createTopic(JMSTopicService.JMS_TOPIC_PREFIX + JMSTopicService.this.name, false, JMSTopicService.this.name, new String[0]);
                    JMSTopicService.this.topic = (Topic)new ActiveMQTopic(JMSTopicService.JMS_TOPIC_PREFIX + JMSTopicService.this.name, JMSTopicService.this.name);
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingLogger.ROOT_LOGGER.failedToCreate(e, "JMS Topic"));
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public synchronized void stop(StopContext context) {
    }

    public Topic getValue() throws IllegalStateException {
        return this.topic;
    }

    public static JMSTopicService installService(String name, ServiceName serverServiceName, ServiceTarget serviceTarget) {
        JMSTopicService service = new JMSTopicService(name);
        ServiceName serviceName = JMSServices.getJmsTopicBaseServiceName(serverServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.requires(ActiveMQActivationService.getServiceName(serverServiceName));
        serviceBuilder.addDependency(JMSServices.getJmsManagerBaseServiceName(serverServiceName), JMSServerManager.class, service.jmsServer);
        serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.executorInjector);
        serviceBuilder.install();
        return service;
    }
}

