/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldStartCompletionService
implements Service<WeldStartCompletionService> {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_START_COMPLETION_SERVICE_NAME;
    private final InjectedValue<WeldBootstrapService> bootstrap = new InjectedValue();
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final ClassLoader classLoader;
    private final List<ServiceController> serviceControllers;
    private final AtomicBoolean runOnce = new AtomicBoolean();

    public WeldStartCompletionService(ClassLoader classLoader, List<ServiceController> serviceControllers) {
        this.classLoader = classLoader;
        this.serviceControllers = serviceControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        if (!this.runOnce.compareAndSet(false, true)) {
            return;
        }
        ExecutorService executor = (ExecutorService)this.executorService.getValue();
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StabilityMonitor monitor = new StabilityMonitor();
                for (ServiceController controller : WeldStartCompletionService.this.serviceControllers) {
                    monitor.addController(controller);
                }
                try {
                    monitor.awaitStability();
                }
                catch (InterruptedException ex) {
                    context.failed(new StartException((Throwable)ex));
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ex);
                }
                finally {
                    monitor.clear();
                }
                ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)WeldStartCompletionService.this.classLoader);
                    ((WeldBootstrapService)WeldStartCompletionService.this.bootstrap.getValue()).getBootstrap().endInitialization();
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                    context.complete();
                }
            }
        };
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public void stop(StopContext context) {
    }

    public WeldStartCompletionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldBootstrapService> getBootstrap() {
        return this.bootstrap;
    }

    public InjectedValue<ExecutorService> getServerExecutor() {
        return this.executorService;
    }
}

