/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.naming.JavaNamespaceSetup;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.service.DefaultNamespaceContextSelectorService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.CdiAnnotationMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.WeldDeployment;
import org.jboss.as.weld.deployment.WeldPortableExtensions;
import org.jboss.as.weld.deployment.processors.WeldConfiguration;
import org.jboss.as.weld.deployment.processors.WildFlyWeldEnvironment;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.TCCLSingletonService;
import org.jboss.as.weld.services.bootstrap.WeldExecutorServices;
import org.jboss.as.weld.spi.BootstrapDependencyInstaller;
import org.jboss.as.weld.spi.DeploymentUnitDependenciesProvider;
import org.jboss.as.weld.spi.ModuleServicesProvider;
import org.jboss.as.weld.util.Reflections;
import org.jboss.as.weld.util.ServiceLoaders;
import org.jboss.as.weld.util.Utils;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.configuration.spi.helpers.ExternalConfigurationBuilder;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldDeploymentProcessor
implements DeploymentUnitProcessor {
    private final boolean jtsEnabled;

    public WeldDeploymentProcessor(boolean jtsEnabled) {
        this.jtsEnabled = jtsEnabled;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = Utils.getRootDeploymentUnit(deploymentUnit);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            if (deploymentUnit.getParent() == null && CdiAnnotationMarker.cdiAnnotationsPresent(deploymentUnit)) {
                WeldLogger.DEPLOYMENT_LOGGER.cdiAnnotationsButNotBeanArchive(deploymentUnit.getName());
            }
            return;
        }
        ServiceName weldBootstrapServiceName = parent.getServiceName().append(WeldBootstrapService.SERVICE_NAME);
        ServiceName weldStartServiceName = parent.getServiceName().append(WeldStartService.SERVICE_NAME);
        deploymentUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)weldStartServiceName);
        HashSet<ServiceName> dependencies = new HashSet<ServiceName>();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        WeldLogger.DEPLOYMENT_LOGGER.startingServicesForCDIDeployment(phaseContext.getDeploymentUnit().getName());
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        HashSet<BeanDeploymentArchiveImpl> beanDeploymentArchives = new HashSet<BeanDeploymentArchiveImpl>();
        HashMap<ModuleIdentifier, BeanDeploymentModule> bdmsByIdentifier = new HashMap<ModuleIdentifier, BeanDeploymentModule>();
        HashMap<ModuleIdentifier, ModuleSpecification> moduleSpecByIdentifier = new HashMap<ModuleIdentifier, ModuleSpecification>();
        HashMap<ModuleIdentifier, EEModuleDescriptor> eeModuleDescriptors = new HashMap<ModuleIdentifier, EEModuleDescriptor>();
        BeanDeploymentModule rootBeanDeploymentModule = (BeanDeploymentModule)deploymentUnit.getAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
        Utils.putIfValueNotNull(eeModuleDescriptors, module.getIdentifier(), rootBeanDeploymentModule.getModuleDescriptor());
        bdmsByIdentifier.put(module.getIdentifier(), rootBeanDeploymentModule);
        moduleSpecByIdentifier.put(module.getIdentifier(), moduleSpecification);
        beanDeploymentArchives.addAll(rootBeanDeploymentModule.getBeanDeploymentArchives());
        List subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        HashSet<ClassLoader> subDeploymentLoaders = new HashSet<ClassLoader>();
        ServiceLoader<DeploymentUnitDependenciesProvider> dependenciesProviders = ServiceLoader.load(DeploymentUnitDependenciesProvider.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldDeploymentProcessor.class));
        ServiceLoader<ModuleServicesProvider> moduleServicesProviders = ServiceLoader.load(ModuleServicesProvider.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldDeploymentProcessor.class));
        this.getDependencies(deploymentUnit, dependencies, dependenciesProviders);
        for (DeploymentUnit deploymentUnit2 : subDeployments) {
            this.getDependencies(deploymentUnit2, dependencies, dependenciesProviders);
            Module module2 = (Module)deploymentUnit2.getAttachment(Attachments.MODULE);
            if (module2 == null) continue;
            subDeploymentLoaders.add((ClassLoader)module2.getClassLoader());
            ModuleSpecification subDeploymentModuleSpec = (ModuleSpecification)deploymentUnit2.getAttachment(Attachments.MODULE_SPECIFICATION);
            BeanDeploymentModule beanDeploymentModule = (BeanDeploymentModule)deploymentUnit2.getAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
            if (beanDeploymentModule == null) continue;
            beanDeploymentArchives.addAll(beanDeploymentModule.getBeanDeploymentArchives());
            bdmsByIdentifier.put(module2.getIdentifier(), beanDeploymentModule);
            moduleSpecByIdentifier.put(module2.getIdentifier(), subDeploymentModuleSpec);
            Utils.putIfValueNotNull(eeModuleDescriptors, module2.getIdentifier(), beanDeploymentModule.getModuleDescriptor());
            ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit2.getAttachment(Attachments.DEPLOYMENT_ROOT);
            for (Map.Entry entry : ServiceLoaders.loadModuleServices(moduleServicesProviders, (DeploymentUnit)deploymentUnit, (DeploymentUnit)deploymentUnit2, (Module)module2, (ResourceRoot)resourceRoot).entrySet()) {
                beanDeploymentModule.addService((Class)entry.getKey(), (org.jboss.weld.bootstrap.api.Service)Reflections.cast(entry.getValue()));
            }
        }
        for (Map.Entry entry : bdmsByIdentifier.entrySet()) {
            ModuleSpecification moduleSpecification2 = (ModuleSpecification)moduleSpecByIdentifier.get(entry.getKey());
            BeanDeploymentModule bdm = (BeanDeploymentModule)entry.getValue();
            if (bdm == rootBeanDeploymentModule) continue;
            for (ModuleDependency moduleDependency : moduleSpecification2.getSystemDependencies()) {
                BeanDeploymentModule other = (BeanDeploymentModule)bdmsByIdentifier.get(moduleDependency.getIdentifier());
                if (other == null || other == bdm) continue;
                bdm.addBeanDeploymentModule(other);
            }
        }
        Map rootModuleServices = ServiceLoaders.loadModuleServices(moduleServicesProviders, (DeploymentUnit)deploymentUnit, (DeploymentUnit)deploymentUnit, (Module)module, (ResourceRoot)deploymentRoot);
        for (Map.Entry entry : rootModuleServices.entrySet()) {
            rootBeanDeploymentModule.addService((Class)entry.getKey(), (org.jboss.weld.bootstrap.api.Service)Reflections.cast(entry.getValue()));
        }
        for (BeanDeploymentArchiveImpl beanDeploymentArchiveImpl : deploymentUnit.getAttachmentList(WeldAttachments.ADDITIONAL_BEAN_DEPLOYMENT_MODULES)) {
            beanDeploymentArchives.add(beanDeploymentArchiveImpl);
            for (Map.Entry entry : rootModuleServices.entrySet()) {
                beanDeploymentArchiveImpl.getServices().add((Class)entry.getKey(), (org.jboss.weld.bootstrap.api.Service)Reflections.cast(entry.getValue()));
            }
        }
        Collection collection = WeldPortableExtensions.getPortableExtensions((DeploymentUnit)deploymentUnit).getExtensions();
        WeldDeployment weldDeployment = new WeldDeployment(beanDeploymentArchives, collection, module, subDeploymentLoaders, deploymentUnit, rootBeanDeploymentModule, eeModuleDescriptors);
        WeldBootstrapService weldBootstrapService = new WeldBootstrapService(weldDeployment, WildFlyWeldEnvironment.INSTANCE, deploymentUnit.getName());
        this.installBootstrapConfigurationService(weldDeployment, parent);
        for (Map.Entry entry : rootModuleServices.entrySet()) {
            weldBootstrapService.addWeldService((Class)entry.getKey(), (org.jboss.weld.bootstrap.api.Service)Reflections.cast(entry.getValue()));
        }
        ServiceBuilder serviceBuilder = serviceTarget.addService(weldBootstrapServiceName, (Service)weldBootstrapService);
        serviceBuilder.requires(TCCLSingletonService.SERVICE_NAME);
        serviceBuilder.addDependency(WeldExecutorServices.SERVICE_NAME, ExecutorServices.class, weldBootstrapService.getExecutorServices());
        serviceBuilder.addDependency(Services.JBOSS_SERVER_EXECUTOR, ExecutorService.class, weldBootstrapService.getServerExecutor());
        ServiceLoader<BootstrapDependencyInstaller> serviceLoader = ServiceLoader.load(BootstrapDependencyInstaller.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldDeploymentProcessor.class));
        for (BootstrapDependencyInstaller installer : serviceLoader) {
            ServiceName serviceName = installer.install(serviceTarget, deploymentUnit, this.jtsEnabled);
            if (ServiceNames.WELD_SECURITY_SERVICES_SERVICE_NAME.getSimpleName().equals(serviceName.getSimpleName())) {
                serviceBuilder.addDependency(serviceName, SecurityServices.class, weldBootstrapService.getSecurityServices());
                continue;
            }
            if (!ServiceNames.WELD_TRANSACTION_SERVICES_SERVICE_NAME.getSimpleName().equals(serviceName.getSimpleName())) continue;
            serviceBuilder.addDependency(serviceName, TransactionServices.class, weldBootstrapService.getWeldTransactionServices());
        }
        serviceBuilder.install();
        ArrayList<SetupAction> setupActions = new ArrayList<SetupAction>();
        JavaNamespaceSetup naming = (JavaNamespaceSetup)deploymentUnit.getAttachment(org.jboss.as.ee.naming.Attachments.JAVA_NAMESPACE_SETUP_ACTION);
        if (naming != null) {
            setupActions.add((SetupAction)naming);
        }
        WeldStartService weldStartService = new WeldStartService(setupActions, (ClassLoader)module.getClassLoader(), Utils.getRootDeploymentUnit(deploymentUnit).getServiceName());
        ServiceBuilder startService = serviceTarget.addService(weldStartServiceName, (Service)weldStartService).addDependency(weldBootstrapServiceName, WeldBootstrapService.class, weldStartService.getBootstrap());
        for (ServiceName dependency : dependencies) {
            startService.requires(dependency);
        }
        startService.requires(JndiNamingDependencyProcessor.serviceName((DeploymentUnit)deploymentUnit));
        CapabilityServiceSupport capabilities = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        boolean tx = capabilities.hasCapability("org.wildfly.transactions");
        for (ServiceName jndiSubsystemDependency : this.getJNDISubsytemDependencies(tx)) {
            startService.requires(jndiSubsystemDependency);
        }
        EarMetaData earConfig = (EarMetaData)deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA);
        if (earConfig == null || !earConfig.getInitializeInOrder()) {
            for (DeploymentUnit sub : subDeployments) {
                startService.requires(JndiNamingDependencyProcessor.serviceName((DeploymentUnit)sub));
            }
        }
        startService.install();
    }

    private List<ServiceName> getJNDISubsytemDependencies(boolean tx) {
        ArrayList<ServiceName> dependencies = new ArrayList<ServiceName>();
        if (tx) {
            dependencies.add(ContextNames.JBOSS_CONTEXT_SERVICE_NAME.append(ServiceName.of((String[])new String[]{"UserTransaction"})));
            dependencies.add(ContextNames.JBOSS_CONTEXT_SERVICE_NAME.append(ServiceName.of((String[])new String[]{"TransactionSynchronizationRegistry"})));
        }
        dependencies.add(NamingService.SERVICE_NAME);
        dependencies.add(DefaultNamespaceContextSelectorService.SERVICE_NAME);
        return dependencies;
    }

    private void installBootstrapConfigurationService(WeldDeployment deployment, DeploymentUnit parentDeploymentUnit) {
        boolean nonPortableMode = ((WeldConfiguration)parentDeploymentUnit.getAttachment(WeldConfiguration.ATTACHMENT_KEY)).isNonPortableMode();
        ExternalConfiguration configuration = new ExternalConfigurationBuilder().add(ConfigurationKey.NON_PORTABLE_MODE.get(), (Object)nonPortableMode).add(ConfigurationKey.ALLOW_OPTIMIZED_CLEANUP.get(), (Object)true).build();
        deployment.getServices().add(ExternalConfiguration.class, (org.jboss.weld.bootstrap.api.Service)configuration);
    }

    private void getDependencies(DeploymentUnit deploymentUnit, Set<ServiceName> dependencies, ServiceLoader<DeploymentUnitDependenciesProvider> providers) {
        for (DeploymentUnitDependenciesProvider provider : providers) {
            dependencies.addAll(provider.getDependencies(deploymentUnit));
        }
    }

    public void undeploy(DeploymentUnit context) {
        ServiceName weldTransactionServiceName = context.getServiceName().append(ServiceNames.WELD_TRANSACTION_SERVICES_SERVICE_NAME);
        ServiceController serviceController = context.getServiceRegistry().getService(weldTransactionServiceName);
        if (serviceController != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

