/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.function.Consumer;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.weld.security.spi.SecurityContext;
import org.jboss.weld.security.spi.SecurityServices;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldSecurityServices
implements Service<WeldSecurityServices>,
SecurityServices {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_SECURITY_SERVICES_SERVICE_NAME;
    private final InjectedValue<?> securityManagerValue = new InjectedValue();

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WeldSecurityServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Principal getPrincipal() {
        SecurityDomain elytronDomain = this.getCurrentSecurityDomain();
        if (elytronDomain != null) {
            return elytronDomain.getCurrentSecurityIdentity().getPrincipal();
        }
        Object securityManager = this.securityManagerValue.getOptionalValue();
        if (securityManager == null) {
            throw WeldLogger.ROOT_LOGGER.securityNotEnabled();
        }
        return ((ServerSecurityManager)securityManager).getCallerPrincipal();
    }

    public void cleanup() {
    }

    public InjectedValue<?> getSecurityManagerValue() {
        return this.securityManagerValue;
    }

    public SecurityContext getSecurityContext() {
        org.jboss.security.SecurityContext ctx = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(() -> SecurityContextAssociation.getSecurityContext()) : SecurityContextAssociation.getSecurityContext();
        return new WeldSecurityContext(ctx);
    }

    public Consumer<Runnable> getSecurityContextAssociator() {
        SecurityDomain elytronDomain = this.getCurrentSecurityDomain();
        if (elytronDomain != null) {
            SecurityIdentity storedSecurityIdentity = elytronDomain.getCurrentSecurityIdentity();
            return action -> storedSecurityIdentity.runAs(action);
        }
        return super.getSecurityContextAssociator();
    }

    private SecurityDomain getCurrentSecurityDomain() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> SecurityDomain.getCurrent());
        }
        return SecurityDomain.getCurrent();
    }

    static class WeldSecurityContext
    implements SecurityContext,
    PrivilegedAction<Void> {
        private final org.jboss.security.SecurityContext ctx;

        WeldSecurityContext(org.jboss.security.SecurityContext ctx) {
            this.ctx = ctx;
        }

        public void associate() {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> this.run());
            } else {
                this.run();
            }
        }

        public void dissociate() {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> {
                    SecurityContextAssociation.clearSecurityContext();
                    return null;
                });
            } else {
                SecurityContextAssociation.clearSecurityContext();
            }
        }

        public void close() {
        }

        @Override
        public Void run() {
            SecurityContextAssociation.setSecurityContext((org.jboss.security.SecurityContext)this.ctx);
            return null;
        }
    }
}

