/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processor;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.as.ee.beanvalidation.BeanValidationAttachments;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.CdiValidatorFactoryService;
import org.jboss.as.weld.ServiceNames;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class CdiBeanValidationFactoryProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ServiceName weldStartService = topLevelDeployment.getServiceName().append(ServiceNames.WELD_START_SERVICE_NAME);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!deploymentUnit.hasAttachment(BeanValidationAttachments.VALIDATOR_FACTORY)) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName serviceName = deploymentUnit.getServiceName().append(CdiValidatorFactoryService.SERVICE_NAME);
        CdiValidatorFactoryService cdiValidatorFactoryService = new CdiValidatorFactoryService(deploymentUnit);
        ServiceBuilder sb = serviceTarget.addService(serviceName, (Service)cdiValidatorFactoryService);
        sb.addDependency(ServiceNames.beanManagerServiceName((DeploymentUnit)deploymentUnit), Object.class, (Injector)new CastingInjector(cdiValidatorFactoryService.getBeanManagerInjector(), BeanManager.class));
        sb.requires(weldStartService);
        sb.install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

