/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.setup.JmxRegistrar;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;
import org.wildfly.extension.microprofile.metrics._private.MicroProfileMetricsLogger;

public class MetricsRegistrationService
implements org.jboss.msc.service.Service<MetricsRegistrationService> {
    private final ImmutableManagementResourceRegistration rootResourceRegistration;
    private final Resource rootResource;
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private final List<String> exposedSubsystems;
    private final boolean exposeAnySubsystem;
    private JmxRegistrar jmxRegistrar;
    private LocalModelControllerClient modelControllerClient;

    static void install(OperationContext context, List<String> exposedSubsystems) {
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileMetricsSubsystemDefinition.WILDFLY_REGISTRATION_SERVICE);
        Supplier modelControllerClientFactory = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class));
        Supplier managementExecutor = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.executor", Executor.class));
        serviceBuilder.requires(ServiceNames.CONFIG_PROVIDER);
        MetricsRegistrationService service = new MetricsRegistrationService(rootResourceRegistration, rootResource, modelControllerClientFactory, managementExecutor, exposedSubsystems);
        serviceBuilder.setInstance((Service)service).install();
    }

    public MetricsRegistrationService(ImmutableManagementResourceRegistration rootResourceRegistration, Resource rootResource, Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor, List<String> exposedSubsystems) {
        this.rootResourceRegistration = rootResourceRegistration;
        this.rootResource = rootResource;
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
        this.exposedSubsystems = exposedSubsystems;
        this.exposeAnySubsystem = exposedSubsystems.remove("*");
    }

    public void start(StartContext context) throws StartException {
        this.jmxRegistrar = new JmxRegistrar();
        try {
            this.jmxRegistrar.init();
        }
        catch (IOException e) {
            throw MicroProfileMetricsLogger.LOGGER.failedInitializeJMXRegistrar(e);
        }
        this.modelControllerClient = this.modelControllerClientFactory.get().createClient(this.managementExecutor.get());
        this.registerMetrics(this.rootResource, this.rootResourceRegistration, MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR), Function.identity());
    }

    public void stop(StopContext context) {
        for (MetricRegistry registry : new MetricRegistry[]{MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE), MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR)}) {
            for (String name : registry.getNames()) {
                registry.remove(name);
            }
        }
        this.modelControllerClient.close();
        this.jmxRegistrar = null;
    }

    public MetricsRegistrationService getValue() {
        return this;
    }

    public Set<String> registerMetrics(Resource rootResource, ImmutableManagementResourceRegistration managementResourceRegistration, MetricRegistry metricRegistry, Function<PathAddress, PathAddress> resourceAddressResolver) {
        Map<PathAddress, Map<String, ModelNode>> metrics = this.findMetrics(rootResource, managementResourceRegistration);
        Set<String> registeredMetrics = this.registerMetrics(metrics, metricRegistry, resourceAddressResolver);
        return registeredMetrics;
    }

    private Map<PathAddress, Map<String, ModelNode>> findMetrics(Resource rootResource, ImmutableManagementResourceRegistration managementResourceRegistration) {
        HashMap<PathAddress, Map<String, ModelNode>> metrics = new HashMap<PathAddress, Map<String, ModelNode>>();
        this.collectMetrics(rootResource, managementResourceRegistration, PathAddress.EMPTY_ADDRESS, metrics);
        return metrics;
    }

    private void collectMetrics(Resource current, ImmutableManagementResourceRegistration managementResourceRegistration, PathAddress address, Map<PathAddress, Map<String, ModelNode>> collectedMetrics) {
        if (!this.isExposingMetrics(address)) {
            return;
        }
        Map attributes = managementResourceRegistration.getAttributes(address);
        ModelNode description = null;
        for (Map.Entry entry : attributes.entrySet()) {
            Map<String, ModelNode> metricsForResource;
            String attributeName = (String)entry.getKey();
            AttributeAccess attributeAccess = (AttributeAccess)entry.getValue();
            if (attributeAccess.getAccessType() != AttributeAccess.AccessType.METRIC || attributeAccess.getStorageType() != AttributeAccess.Storage.RUNTIME) continue;
            if (description == null) {
                DescriptionProvider modelDescription = managementResourceRegistration.getModelDescription(address);
                description = modelDescription.getModelDescription(Locale.getDefault());
            }
            if ((metricsForResource = collectedMetrics.get(address)) == null) {
                metricsForResource = new HashMap<String, ModelNode>();
            }
            metricsForResource.put(attributeName, description.get(new String[]{"attributes", attributeName}));
            collectedMetrics.put(address, metricsForResource);
        }
        for (String type : current.getChildTypes()) {
            if (!current.hasChildren(type)) continue;
            for (Resource.ResourceEntry entry : current.getChildren(type)) {
                PathElement pathElement = entry.getPathElement();
                PathAddress childAddress = address.append(new PathElement[]{pathElement});
                this.collectMetrics((Resource)entry, managementResourceRegistration, childAddress, collectedMetrics);
            }
        }
    }

    public Set<String> registerMetrics(Map<PathAddress, Map<String, ModelNode>> metrics, final MetricRegistry registry, Function<PathAddress, PathAddress> resourceAddressResolver) {
        HashSet<String> registeredMetricNames = new HashSet<String>();
        for (Map.Entry<PathAddress, Map<String, ModelNode>> entry : metrics.entrySet()) {
            final PathAddress resourceAddress = resourceAddressResolver.apply(entry.getKey());
            block4: for (Map.Entry<String, ModelNode> wildflyMetric : entry.getValue().entrySet()) {
                final String attributeName = wildflyMetric.getKey();
                ModelNode attributeDescription = wildflyMetric.getValue();
                final String metricName = resourceAddress.toPathStyleString().substring(1) + "/" + attributeName;
                String unit = attributeDescription.get("unit").asString("none").toLowerCase();
                String description = attributeDescription.get("description").asStringOrNull();
                HashMap<String, String> tags = new HashMap<String, String>();
                for (PathElement element : resourceAddress) {
                    tags.put(element.getKey(), element.getValue());
                }
                tags.put("attribute", attributeName);
                ExtendedMetadata metadata = new ExtendedMetadata(metricName, attributeName + " for " + resourceAddress.toHttpStyleString(), description, MetricType.GAUGE, unit);
                metadata.setTags(tags);
                final ModelType type = attributeDescription.get("type").asType();
                switch (type) {
                    case BIG_DECIMAL: 
                    case BIG_INTEGER: 
                    case DOUBLE: 
                    case INT: 
                    case LONG: {
                        break;
                    }
                    default: {
                        MicroProfileMetricsLogger.LOGGER.debugf("Type %s is not supported for MicroProfile Metrics, the attribute %s on %s will not be registered.", type, attributeName, resourceAddress);
                        continue block4;
                    }
                }
                Gauge metric = new Gauge(){

                    public Number getValue() {
                        ModelNode readAttributeOp = new ModelNode();
                        readAttributeOp.get("operation").set("read-attribute");
                        readAttributeOp.get("address").set(resourceAddress.toModelNode());
                        readAttributeOp.get("include-undefined-metric-values").set(true);
                        readAttributeOp.get("name").set(attributeName);
                        ModelNode response = MetricsRegistrationService.this.modelControllerClient.execute(readAttributeOp);
                        String error = MetricsRegistrationService.this.getFailureDescription(response);
                        if (error != null) {
                            registry.remove(metricName);
                            throw MicroProfileMetricsLogger.LOGGER.unableToReadAttribute(attributeName, resourceAddress, error);
                        }
                        ModelNode result = response.get("result");
                        if (result.isDefined()) {
                            try {
                                switch (type) {
                                    case INT: {
                                        return result.asInt();
                                    }
                                    case LONG: {
                                        return result.asLong();
                                    }
                                }
                                return result.asDouble();
                            }
                            catch (Exception e) {
                                throw MicroProfileMetricsLogger.LOGGER.unableToConvertAttribute(attributeName, resourceAddress, e);
                            }
                        }
                        registry.remove(metricName);
                        throw MicroProfileMetricsLogger.LOGGER.undefinedMetric(attributeName, resourceAddress);
                    }
                };
                registry.register((Metadata)metadata, (Metric)metric);
                registeredMetricNames.add(metadata.getName());
            }
        }
        return registeredMetricNames;
    }

    private boolean isExposingMetrics(PathAddress address) {
        if (address.size() == 0) {
            return true;
        }
        if (address.getElement(0).getKey().equals("subsystem")) {
            String subsystemName = address.getElement(0).getValue();
            return this.exposeAnySubsystem || this.exposedSubsystems.contains(subsystemName);
        }
        return false;
    }

    private boolean isMetric(AttributeAccess attributeAccess) {
        return attributeAccess.getAccessType() == AttributeAccess.AccessType.METRIC && attributeAccess.getStorageType() == AttributeAccess.Storage.RUNTIME;
    }

    private String getFailureDescription(ModelNode result) {
        if (result.hasDefined("failure-description")) {
            return result.get("failure-description").toString();
        }
        return null;
    }
}

