/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.management.MBeanServer;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.ResourceDMBean;

public abstract class AbstractJmxRegistration {
    protected ComponentsJmxRegistration registrar;
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    BasicComponentRegistry basicComponentRegistry;
    @Inject
    ComponentMetadataRepo componentMetadataRepo;
    String jmxDomain;
    MBeanServer mBeanServer;

    protected abstract ComponentsJmxRegistration buildRegistrar();

    protected void initMBeanServer(GlobalConfiguration globalConfig) {
        try {
            this.mBeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)globalConfig.globalJmxStatistics().mbeanServerLookup(), (Properties)globalConfig.globalJmxStatistics().properties());
        }
        catch (Exception e) {
            this.mBeanServer = null;
        }
        if (this.mBeanServer != null) {
            this.registrar = this.buildRegistrar();
        }
    }

    protected void unregisterMBeans(Collection<ResourceDMBean> resourceDMBeans) {
        if (this.mBeanServer != null) {
            ComponentsJmxRegistration registrar = this.buildRegistrar();
            registrar.unregisterMBeans(resourceDMBeans);
        }
    }

    protected Collection<ResourceDMBean> getResourceDMBeansFromComponents(Collection<ComponentRef<?>> components) {
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>(components.size());
        for (ComponentRef<?> component : components) {
            Object instance = component.wired();
            ResourceDMBean resourceDMBean = this.getResourceDMBean(instance);
            if (resourceDMBean == null) continue;
            resourceDMBeans.add(resourceDMBean);
        }
        return resourceDMBeans;
    }

    protected ResourceDMBean getResourceDMBean(Object instance) {
        ResourceDMBean resourceDMBean;
        ComponentMetadata md;
        ComponentMetadata componentMetadata = md = instance != null ? this.componentMetadataRepo.getComponentMetadata(instance.getClass()) : null;
        if (md == null || !md.isManageable()) {
            return null;
        }
        try {
            resourceDMBean = new ResourceDMBean(instance, md.toManageableComponentMetadata());
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new CacheConfigurationException((Exception)e);
        }
        return resourceDMBean;
    }
}

