/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.net.URI;
import org.wildfly.common.Assert;

public final class ConnectionBuilder {
    private final URI destination;
    private int readTimeout = -1;
    private int writeTimeout = -1;
    private boolean setTcpKeepAlive;
    private boolean tcpKeepAlive;
    private int ipTrafficClass = -1;
    private int heartbeatInterval = -1;

    ConnectionBuilder(URI destination) {
        this.destination = destination;
    }

    public ConnectionBuilder setReadTimeout(int readTimeout) {
        Assert.checkMinimumParameter((String)"readTimeout", (long)1L, (long)readTimeout);
        this.readTimeout = readTimeout;
        return this;
    }

    public ConnectionBuilder setWriteTimeout(int writeTimeout) {
        Assert.checkMinimumParameter((String)"writeTimeout", (long)1L, (long)writeTimeout);
        this.writeTimeout = writeTimeout;
        return this;
    }

    public ConnectionBuilder setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
        this.setTcpKeepAlive = true;
        return this;
    }

    public ConnectionBuilder setIpTrafficClass(int ipTrafficClass) {
        this.ipTrafficClass = ipTrafficClass;
        return this;
    }

    public ConnectionBuilder setHeartbeatInterval(int heartbeatInterval) {
        Assert.checkMinimumParameter((String)"heartbeatInterval", (int)1, (int)heartbeatInterval);
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    URI getDestination() {
        return this.destination;
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    int getWriteTimeout() {
        return this.writeTimeout;
    }

    boolean isSetTcpKeepAlive() {
        return this.setTcpKeepAlive;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    int getIPTrafficClass() {
        return this.ipTrafficClass;
    }

    int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }
}

