/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.interceptors.MetricResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.jboss.logging.Logger;

@Counted
@Interceptor
@Priority(value=1010)
public class CountedInterceptor {
    private static final Logger log = Logger.getLogger(CountedInterceptor.class);
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private CountedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    private Object countedConstructor(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object countedMethod(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object countedTimeout(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object countedCallable(InvocationContext context, E element) throws Exception {
        MetricResolver.Of<Counted> counted = this.resolver.counted(this.bean != null ? this.bean.getBeanClass() : element.getDeclaringClass(), element);
        String name = counted.metricName();
        Counter counter = (Counter)this.registry.getCounters().get(name);
        if (counter == null) {
            throw new IllegalStateException("No counter with name [" + name + "] found in registry [" + this.registry + "]");
        }
        log.debugf("Increment counter [metricName: %s]", (Object)name);
        counter.inc();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (!counted.metricAnnotation().monotonic()) {
                log.debugf("Decrement counter [metricName: %s]", (Object)name);
                counter.dec();
            }
        }
    }
}

