/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.Lockable;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;

final class OptionalDependencyImpl
implements Dependency,
Dependent {
    private final Dependency dependency;
    private volatile Dependent dependent;
    private volatile boolean available = true;

    OptionalDependencyImpl(Dependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public void addDependent(Dependent dependent) {
        assert (this.dependent == null);
        this.dependent = dependent;
        this.dependency.addDependent(this);
    }

    @Override
    public void removeDependent(Dependent dependent) {
        assert (this.dependent == dependent);
        this.dependency.removeDependent(this);
        this.dependent = null;
    }

    @Override
    public void addDemand() {
        this.dependency.addDemand();
    }

    @Override
    public void removeDemand() {
        this.dependency.removeDemand();
    }

    @Override
    public void dependentStarted() {
        this.dependency.dependentStarted();
    }

    @Override
    public void dependentStopped() {
        this.dependency.dependentStopped();
    }

    @Override
    public Object getValue() {
        try {
            return this.available ? this.dependency.getValue() : null;
        }
        catch (IllegalStateException ignored) {
            return null;
        }
    }

    @Override
    public ServiceName getName() {
        return this.dependency.getName();
    }

    @Override
    public ServiceControllerImpl<?> getDependencyController() {
        return this.dependency.getDependencyController();
    }

    @Override
    public void dependencyAvailable() {
        this.available = true;
        Dependent dependent = this.dependent;
        if (dependent != null) {
            dependent.dependencyDown();
        }
    }

    @Override
    public void dependencyUnavailable() {
        this.available = false;
        Dependent dependent = this.dependent;
        if (dependent != null) {
            dependent.dependencyUp();
        }
    }

    @Override
    public void dependencyUp() {
        Dependent dependent = this.dependent;
        if (dependent != null) {
            dependent.dependencyUp();
        }
    }

    @Override
    public void dependencyDown() {
        Dependent dependent = this.dependent;
        if (dependent != null) {
            dependent.dependencyDown();
        }
    }

    @Override
    public void dependencyFailed() {
        Dependent dependent = this.dependent;
        if (dependent != null) {
            dependent.dependencyFailed();
        }
    }

    @Override
    public void dependencySucceeded() {
        Dependent dependent = this.dependent;
        if (dependent != null) {
            dependent.dependencySucceeded();
        }
    }

    @Override
    public ServiceControllerImpl<?> getDependentController() {
        Dependent dependent = this.dependent;
        return dependent != null ? dependent.getDependentController() : null;
    }

    @Override
    public Lockable getLock() {
        return this.dependency.getLock();
    }
}

