/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.discovery;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.extension.discovery.DiscoverySubsystemDefinition;
import org.wildfly.extension.discovery.DiscoverySubsystemParser;

public final class DiscoveryExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "discovery";
    static final String NAMESPACE = "urn:jboss:domain:discovery:1.0";
    static final String ABSTRACT_TYPE = "abstract-type";
    static final String ABSTRACT_TYPE_AUTHORITY = "abstract-type-authority";
    static final String AGGREGATE_PROVIDER = "aggregate-provider";
    static final String ATTRIBUTE = "attribute";
    static final String ATTRIBUTES = "attributes";
    static final String DISCOVERY = "discovery";
    static final String NAME = "name";
    static final String PROVIDERS = "providers";
    static final String SERVICE = "service";
    static final String SERVICES = "services";
    static final String STATIC_PROVIDER = "static-provider";
    static final String URI = "uri";
    static final String URI_SCHEME_AUTHORITY = "uri-scheme-authority";
    static final String VALUE = "value";
    static final String RESOURCE_NAME = DiscoveryExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"discovery");
    static final String DISCOVERY_PROVIDER_CAPABILITY = "org.wildfly.discovery.provider";
    static final RuntimeCapability<?> DISCOVERY_PROVIDER_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.discovery.provider", (boolean)true).setServiceType(DiscoveryProvider.class).build();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem("discovery", ModelVersion.create((int)1, (int)0));
        subsystemRegistration.setHostCapable();
        subsystemRegistration.registerXMLElementWriter(DiscoverySubsystemParser::new);
        ManagementResourceRegistration resourceRegistration = subsystemRegistration.registerSubsystemModel(DiscoverySubsystemDefinition.getInstance());
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping("discovery", NAMESPACE, (XMLElementReader)new DiscoverySubsystemParser());
    }

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefixes) {
        StringBuilder sb = new StringBuilder("discovery");
        if (keyPrefixes != null) {
            for (String current : keyPrefixes) {
                sb.append(".").append(current);
            }
        }
        return new StandardResourceDescriptionResolver(sb.toString(), RESOURCE_NAME, DiscoveryExtension.class.getClassLoader(), true, false);
    }
}

