/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.util.AttachmentKey;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.IdentifierSerializer;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.undertow.UndertowIdentifierSerializerProvider;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.DistributableImmutableSession;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSessionManager
implements UndertowSessionManager,
Consumer<HttpServerExchange> {
    private static final IdentifierSerializer IDENTIFIER_SERIALIZER = new UndertowIdentifierSerializerProvider().getSerializer();
    private final AttachmentKey<io.undertow.server.session.Session> key = AttachmentKey.create(io.undertow.server.session.Session.class);
    private final String deploymentName;
    private final SessionListeners listeners;
    private final SessionManager<LocalSessionContext, Batch> manager;
    private final RecordableSessionManagerStatistics statistics;

    public DistributableSessionManager(String deploymentName, SessionManager<LocalSessionContext, Batch> manager, SessionListeners listeners, RecordableSessionManagerStatistics statistics) {
        this.deploymentName = deploymentName;
        this.manager = manager;
        this.listeners = listeners;
        this.statistics = statistics;
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.listeners;
    }

    @Override
    public SessionManager<LocalSessionContext, Batch> getSessionManager() {
        return this.manager;
    }

    public synchronized void start() {
        this.manager.start();
        if (this.statistics != null) {
            this.statistics.reset();
        }
    }

    public synchronized void stop() {
        this.manager.stop();
    }

    @Override
    public void accept(HttpServerExchange exchange) {
        if (exchange != null) {
            exchange.removeAttachment(this.key);
        }
    }

    public io.undertow.server.session.Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String requestedId = config.findSessionId(exchange);
        String id = requestedId == null ? (String)this.manager.createIdentifier() : requestedId;
        boolean close = true;
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            Session session = this.manager.createSession(id);
            if (session == null) {
                throw UndertowClusteringLogger.ROOT_LOGGER.sessionAlreadyExists(id);
            }
            if (requestedId == null) {
                config.setSessionId(exchange, id);
            }
            DistributableSession result = new DistributableSession(this, (Session<LocalSessionContext>)session, config, batcher.suspendBatch(), this);
            this.listeners.sessionCreated((io.undertow.server.session.Session)result, exchange);
            if (this.statistics != null) {
                this.statistics.record(result);
            }
            close = false;
            exchange.putAttachment(this.key, (Object)result);
            DistributableSession distributableSession = result;
            return distributableSession;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }

    public io.undertow.server.session.Session getSession(HttpServerExchange exchange, SessionConfig config) {
        io.undertow.server.session.Session attachedSession;
        if (exchange != null && (attachedSession = (io.undertow.server.session.Session)exchange.getAttachment(this.key)) != null) {
            return attachedSession;
        }
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String id = config.findSessionId(exchange);
        if (id == null) {
            return null;
        }
        if (!IDENTIFIER_SERIALIZER.validate(id)) {
            return null;
        }
        boolean close = true;
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            Session session = this.manager.findSession(id);
            if (session == null) {
                io.undertow.server.session.Session session2 = null;
                return session2;
            }
            DistributableSession result = new DistributableSession(this, (Session<LocalSessionContext>)session, config, batcher.suspendBatch(), this);
            close = false;
            if (exchange != null) {
                exchange.putAttachment(this.key, (Object)result);
            }
            DistributableSession distributableSession = result;
            return distributableSession;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }

    public void registerSessionListener(SessionListener listener) {
        this.listeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.manager.setDefaultMaxInactiveInterval(Duration.ofSeconds(timeout));
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getLocalSessions();
    }

    public io.undertow.server.session.Session getSession(String sessionId) {
        if (!IDENTIFIER_SERIALIZER.validate(sessionId)) {
            return null;
        }
        Throwable throwable = null;
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.viewSession(sessionId);
            DistributableImmutableSession distributableImmutableSession = session != null ? new DistributableImmutableSession(this, session) : null;
            return distributableImmutableSession;
        }
        catch (Error | RuntimeException e) {
            try {
                batch.discard();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public SessionManagerStatistics getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DistributableSessionManager)) {
            return false;
        }
        DistributableSessionManager manager = (DistributableSessionManager)object;
        return this.deploymentName.equals(manager.getDeploymentName());
    }

    public int hashCode() {
        return this.deploymentName.hashCode();
    }

    public String toString() {
        return this.deploymentName;
    }
}

