/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.DatabaseDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem20Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.RemotingEjbReceiverDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem30Parser
extends EJB3Subsystem20Parser {
    protected EJB3Subsystem30Parser() {
    }

    @Override
    protected EJB3SubsystemNamespace getExpectedNamespace() {
        return EJB3SubsystemNamespace.EJB3_3_0;
    }

    @Override
    protected void readElement(XMLExtendedStreamReader reader, EJB3SubsystemXMLElement element, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        switch (element) {
            case LOG_SYSTEM_EXCEPTIONS: {
                this.parseLogEjbExceptions(reader, ejb3SubsystemAddOperation);
                break;
            }
            default: {
                super.readElement(reader, element, operations, ejb3SubsystemAddOperation);
            }
        }
    }

    private void parseLogEjbExceptions(XMLExtendedStreamReader reader, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.VALUE);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.VALUE);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }

    @Override
    protected void parseDatabaseDataStore(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        ModelNode databaseDataStore = new ModelNode();
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.NAME, EJB3SubsystemXMLAttribute.DATASOURCE_JNDI_NAME);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (name != null) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    name = reader.getAttributeValue(i);
                    continue block8;
                }
                case DATASOURCE_JNDI_NAME: {
                    DatabaseDataStoreResourceDefinition.DATASOURCE_JNDI_NAME.parseAndSetParameter(value, databaseDataStore, (XMLStreamReader)reader);
                    continue block8;
                }
                case DATABASE: {
                    DatabaseDataStoreResourceDefinition.DATABASE.parseAndSetParameter(value, databaseDataStore, (XMLStreamReader)reader);
                    continue block8;
                }
                case PARTITION: {
                    DatabaseDataStoreResourceDefinition.PARTITION.parseAndSetParameter(value, databaseDataStore, (XMLStreamReader)reader);
                    continue block8;
                }
                case REFRESH_INTERVAL: {
                    DatabaseDataStoreResourceDefinition.REFRESH_INTERVAL.parseAndSetParameter(value, databaseDataStore, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALLOW_EXECUTION: {
                    DatabaseDataStoreResourceDefinition.ALLOW_EXECUTION.parseAndSetParameter(value, databaseDataStore, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "timer-service");
        address.add("database-data-store", name);
        databaseDataStore.get("operation").set("add");
        databaseDataStore.get("address").set(address);
        operations.add(databaseDataStore);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    @Override
    protected void parseRemote(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        PathAddress ejb3RemoteServiceAddress = SUBSYSTEM_PATH.append("service", "remote");
        ModelNode operation = Util.createAddOperation((PathAddress)ejb3RemoteServiceAddress);
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.CONNECTOR_REF, EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CONNECTOR_REF: {
                    EJB3RemoteResourceDefinition.CONNECTOR_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case THREAD_POOL_NAME: {
                    EJB3RemoteResourceDefinition.THREAD_POOL_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        operation.get("execute-in-worker").set(new ModelNode(false));
        operations.add(operation);
        HashSet<EJB3SubsystemXMLElement> parsedElements = new HashSet<EJB3SubsystemXMLElement>();
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            EJB3SubsystemXMLElement element = EJB3SubsystemXMLElement.forName(reader.getLocalName());
            switch (element) {
                case CHANNEL_CREATION_OPTIONS: {
                    if (parsedElements.contains((Object)EJB3SubsystemXMLElement.CHANNEL_CREATION_OPTIONS)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    parsedElements.add(EJB3SubsystemXMLElement.CHANNEL_CREATION_OPTIONS);
                    this.parseChannelCreationOptions(reader, ejb3RemoteServiceAddress, operations);
                    continue block9;
                }
                case PROFILES: {
                    this.parseProfiles(reader, operations);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseProfiles(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case PROFILE: {
                    this.parseProfile(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseProfile(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String profileName = null;
        ModelNode operation = Util.createAddOperation();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    profileName = value;
                    continue block8;
                }
                case EXCLUDE_LOCAL_RECEIVER: {
                    RemotingProfileResourceDefinition.EXCLUDE_LOCAL_RECEIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    RemotingProfileResourceDefinition.LOCAL_RECEIVER_PASS_BY_VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        PathAddress address = SUBSYSTEM_PATH.append("remoting-profile", profileName);
        operation.get("address").set(address.toModelNode());
        operations.add(operation);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case REMOTING_EJB_RECEIVER: {
                    this.parseRemotingReceiver(reader, address, operations);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (profileName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
    }

    protected void parseRemotingReceiver(XMLExtendedStreamReader reader, PathAddress profileAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.OUTBOUND_CONNECTION_REF);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case OUTBOUND_CONNECTION_REF: {
                    RemotingEjbReceiverDefinition.OUTBOUND_CONNECTION_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case CONNECT_TIMEOUT: {
                    RemotingEjbReceiverDefinition.CONNECT_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress receiverAddress = profileAddress.append("remoting-ejb-receiver", name);
        operation.get("address").set(receiverAddress.toModelNode());
        operations.add(operation);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case CHANNEL_CREATION_OPTIONS: {
                    this.parseChannelCreationOptions(reader, receiverAddress, operations);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

